/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.io.Serializable;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Record;

public class CacheKey
implements Serializable,
Cloneable {
    protected Object key;
    protected Object object;
    protected IdentityMap mapOwner;
    protected Object writeLockValue;
    protected Object wrapper;
    protected ConcurrencyManager mutex;
    protected Record record;
    protected long lastUpdatedQueryId;
    protected int invalidationState = 0;
    public static final int CHECK_INVALIDATION_POLICY = 0;
    public static final int CACHE_KEY_INVALID = -1;
    public static final int MAX_WAIT_TRIES = 10000;
    protected long readTime = 0L;
    protected boolean isWrapper = false;
    protected AbstractRecord protectedForeignKeys;
    protected boolean isIsolated;

    protected CacheKey() {
    }

    public CacheKey(Object primaryKey) {
        this.key = primaryKey;
    }

    public CacheKey(Object primaryKey, Object object, Object lockValue) {
        this.key = primaryKey;
        this.writeLockValue = lockValue;
        if (object != null) {
            this.setObject(object);
        }
    }

    public CacheKey(Object primaryKey, Object object, Object lockValue, long readTime, boolean isIsolated) {
        this.key = primaryKey;
        this.writeLockValue = lockValue;
        if (object != null) {
            this.setObject(object);
        }
        this.readTime = readTime;
        this.isIsolated = isIsolated;
    }

    public void acquire() {
        this.getMutex().acquire(false);
    }

    public void acquire(boolean forMerge) {
        this.getMutex().acquire(forMerge);
    }

    public boolean acquireNoWait() {
        return this.getMutex().acquireNoWait(false);
    }

    public boolean acquireIfUnownedNoWait() {
        return this.getMutex().acquireIfUnownedNoWait(false);
    }

    public boolean acquireNoWait(boolean forMerge) {
        return this.getMutex().acquireNoWait(forMerge);
    }

    public boolean acquireWithWait(boolean forMerge, int wait) {
        return this.getMutex().acquireWithWait(forMerge, wait);
    }

    public void acquireDeferredLock() {
        this.getMutex().acquireDeferredLock();
    }

    public void checkReadLock() {
        this.getMutex().checkReadLock();
    }

    public void checkDeferredLock() {
        this.getMutex().checkDeferredLock();
    }

    public void acquireReadLock() {
        this.getMutex().acquireReadLock();
    }

    public boolean acquireReadLockNoWait() {
        return this.getMutex().acquireReadLockNoWait();
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        return object;
    }

    public boolean equals(Object object) {
        try {
            return this.equals((CacheKey)object);
        }
        catch (ClassCastException incorrectType) {
            return false;
        }
    }

    public boolean equals(CacheKey key) {
        if (this == key) {
            return true;
        }
        return this.key.equals(key.key);
    }

    public long getLastUpdatedQueryId() {
        return this.lastUpdatedQueryId;
    }

    public Object getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrencyManager getMutex() {
        if (this.mutex == null) {
            CacheKey cacheKey = this;
            synchronized (cacheKey) {
                if (this.mutex == null) {
                    this.mutex = new ConcurrencyManager(this);
                }
            }
        }
        return this.mutex;
    }

    public Object getObject() {
        return this.object;
    }

    public IdentityMap getOwningMap() {
        return this.mapOwner;
    }

    public long getReadTime() {
        return this.readTime;
    }

    public Record getRecord() {
        return this.record;
    }

    public Object getWrapper() {
        return this.wrapper;
    }

    public CacheKey getWrappedCacheKey() {
        return this;
    }

    public Object getWriteLockValue() {
        return this.writeLockValue;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean isAcquired() {
        return this.getMutex().isAcquired();
    }

    public boolean isIsolated() {
        return this.isIsolated;
    }

    public boolean isWrapper() {
        return this.isWrapper;
    }

    public AbstractRecord getProtectedForeignKeys() {
        if (this.protectedForeignKeys == null) {
            this.protectedForeignKeys = new DatabaseRecord();
        }
        return this.protectedForeignKeys;
    }

    public int getInvalidationState() {
        return this.invalidationState;
    }

    public void release() {
        this.getMutex().release();
    }

    public void releaseDeferredLock() {
        this.getMutex().releaseDeferredLock();
    }

    public void releaseReadLock() {
        this.getMutex().releaseReadLock();
    }

    public Object removeFromOwningMap() {
        if (this.getOwningMap() != null) {
            return this.getOwningMap().remove(this);
        }
        return null;
    }

    public void setInvalidationState(int invalidationState) {
        this.invalidationState = invalidationState;
    }

    public void setLastUpdatedQueryId(long id) {
        this.lastUpdatedQueryId = id;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public void setMutex(ConcurrencyManager mutex) {
        this.mutex = mutex;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setOwningMap(IdentityMap map) {
        this.mapOwner = map;
    }

    public void setProtectedForeignKeys(AbstractRecord protectedForeignKeys) {
        this.protectedForeignKeys = protectedForeignKeys;
    }

    public void setReadTime(long readTime) {
        this.readTime = readTime;
        this.invalidationState = 0;
    }

    public void setRecord(Record newRecord) {
        this.record = newRecord;
    }

    public void setWrapper(Object wrapper) {
        this.wrapper = wrapper;
    }

    public void setWriteLockValue(Object writeLockValue) {
        this.writeLockValue = writeLockValue;
    }

    public String toString() {
        int hashCode = 0;
        if (this.getObject() != null) {
            hashCode = this.getObject().hashCode();
        }
        return "[" + this.getKey() + ": " + hashCode + ": " + this.getWriteLockValue() + ": " + this.getReadTime() + ": " + this.getObject() + "]";
    }

    public void transitionToDeferredLock() {
        this.getMutex().transitionToDeferredLock();
    }

    public void updateAccess() {
    }

    public void setIsolated(boolean isIsolated) {
        this.isIsolated = isIsolated;
    }

    public void setIsWrapper(boolean isWrapper) {
        this.isWrapper = isWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForObject() {
        ConcurrencyManager concurrencyManager = this.getMutex();
        synchronized (concurrencyManager) {
            try {
                int count = 0;
                while (this.object == null && this.isAcquired()) {
                    if (count > 10000) {
                        throw ConcurrencyException.maxTriesLockOnBuildObjectExceded(this.getMutex().getActiveThread(), Thread.currentThread());
                    }
                    this.getMutex().wait(10L);
                    ++count;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.object;
        }
    }
}

