/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.bind.ValidationEventHandler;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.IDResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDResolverWrapper
extends IDResolver {
    private static final String BIND_METHOD_NAME = "bind";
    private static final String END_DOCUMENT_METHOD_NAME = "endDocument";
    private static final String RESOLVE_METHOD_NAME = "resolve";
    private static final String START_DOCUMENT_METHOD_NAME = "startDocument";
    private static final Class[] BIND_PARAMS = new Class[]{ClassConstants.STRING, ClassConstants.OBJECT};
    private static final Class[] RESOLVE_PARAMS = new Class[]{ClassConstants.STRING, ClassConstants.CLASS};
    private static final Class[] START_DOCUMENT_PARAMS = new Class[]{ValidationEventHandler.class};
    private Object resolver;
    private Method bindMethod;
    private Method endDocumentMethod;
    private Method resolveMethod;
    private Method startDocumentMethod;

    public IDResolverWrapper(Object sunResolver) {
        this.resolver = sunResolver;
        Class<?> resolverClass = sunResolver.getClass();
        try {
            this.bindMethod = PrivilegedAccessHelper.getMethod(resolverClass, (String)BIND_METHOD_NAME, (Class[])BIND_PARAMS, (boolean)false);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorProcessingIDResolver((String)BIND_METHOD_NAME, (Object)sunResolver, (Throwable)ex);
        }
        try {
            this.endDocumentMethod = PrivilegedAccessHelper.getMethod(resolverClass, (String)END_DOCUMENT_METHOD_NAME, (Class[])new Class[0], (boolean)false);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorProcessingIDResolver((String)END_DOCUMENT_METHOD_NAME, (Object)sunResolver, (Throwable)ex);
        }
        try {
            this.resolveMethod = PrivilegedAccessHelper.getMethod(resolverClass, (String)RESOLVE_METHOD_NAME, (Class[])RESOLVE_PARAMS, (boolean)false);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorProcessingIDResolver((String)RESOLVE_METHOD_NAME, (Object)sunResolver, (Throwable)ex);
        }
        try {
            this.startDocumentMethod = PrivilegedAccessHelper.getMethod(resolverClass, (String)START_DOCUMENT_METHOD_NAME, (Class[])START_DOCUMENT_PARAMS, (boolean)false);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorProcessingIDResolver((String)START_DOCUMENT_METHOD_NAME, (Object)sunResolver, (Throwable)ex);
        }
    }

    public void bind(Object id, Object obj) throws SAXException {
        try {
            Object[] params = new Object[]{id.toString(), obj};
            PrivilegedAccessHelper.invokeMethod((Method)this.bindMethod, (Object)this.resolver, (Object[])params);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorInvokingIDResolver((String)BIND_METHOD_NAME, (Object)this.resolver, (Throwable)ex);
        }
    }

    public void endDocument() throws SAXException {
        try {
            PrivilegedAccessHelper.invokeMethod((Method)this.endDocumentMethod, (Object)this.resolver, (Object[])new Object[0]);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorInvokingIDResolver((String)END_DOCUMENT_METHOD_NAME, (Object)this.resolver, (Throwable)ex);
        }
    }

    @Override
    public void startDocument(ValidationEventHandler eventHandler) throws SAXException {
        try {
            Object[] params = new Object[]{eventHandler};
            PrivilegedAccessHelper.invokeMethod((Method)this.startDocumentMethod, (Object)this.resolver, (Object[])params);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorInvokingIDResolver((String)START_DOCUMENT_METHOD_NAME, (Object)this.resolver, (Throwable)ex);
        }
    }

    public Callable<?> resolve(Object id, Class targetType) throws SAXException {
        try {
            Object[] params = new Object[]{id.toString(), targetType};
            return (Callable)PrivilegedAccessHelper.invokeMethod((Method)this.resolveMethod, (Object)this.resolver, (Object[])params);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorInvokingIDResolver((String)RESOLVE_METHOD_NAME, (Object)this.resolver, (Throwable)ex);
        }
    }

    public Callable<?> resolve(Map<String, Object> id, Class type) throws SAXException {
        throw XMLMarshalException.wrappedIDResolverWithMultiID((String)id.toString(), (Object)this.resolver);
    }

    public void bind(Map<String, Object> id, Object obj) throws SAXException {
        throw XMLMarshalException.wrappedIDResolverWithMultiID((String)id.toString(), (Object)this.resolver);
    }

    public Object getResolver() {
        return this.resolver;
    }
}

