/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.changetracking;

import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangeTrackingPolicy;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.AggregateAttributeChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.FetchGroup;

public class AttributeChangeTrackingPolicy
extends ObjectChangeTrackingPolicy {
    public ObjectChangeSet calculateChangesForExistingObject(Object clone, UnitOfWorkChangeSet changeSet, UnitOfWorkImpl unitOfWork, ClassDescriptor descriptor, boolean shouldRaiseEvent) {
        return this.calculateChanges(clone, null, false, changeSet, unitOfWork, descriptor, shouldRaiseEvent);
    }

    public ObjectChangeSet createObjectChangeSet(Object clone, Object backUp, UnitOfWorkChangeSet changeSet, boolean isNew, AbstractSession session, ClassDescriptor descriptor) {
        ObjectChangeSet changes = null;
        if (!isNew) {
            AttributeChangeListener listener = (AttributeChangeListener)((ChangeTracker)clone)._persistence_getPropertyChangeListener();
            if (listener != null) {
                changes = listener.getObjectChangeSet();
            }
            if (changes != null) {
                if (changes.getUOWChangeSet() != changeSet) {
                    changes = changeSet.mergeObjectChanges(changes, (UnitOfWorkChangeSet)changes.getUOWChangeSet());
                }
                if (changes.hasDeferredAttributes()) {
                    Iterator<String> iterator = changes.getDeferredSet().iterator();
                    while (iterator.hasNext()) {
                        DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(iterator.next());
                        mapping.calculateDeferredChanges((ChangeRecord)changes.getChangesForAttributeNamed(mapping.getAttributeName()), session);
                    }
                    changes.getDeferredSet().clear();
                }
            } else {
                changes = descriptor.getObjectBuilder().createObjectChangeSet(clone, changeSet, isNew, session);
            }
        } else {
            changes = descriptor.getObjectBuilder().createObjectChangeSet(clone, changeSet, isNew, true, session);
            if (descriptor.shouldUseFullChangeSetsForNewObjects() || descriptor.isAggregateDescriptor()) {
                FetchGroup fetchGroup = null;
                if (descriptor.hasFetchGroupManager()) {
                    fetchGroup = descriptor.getFetchGroupManager().getObjectFetchGroup(clone);
                }
                Vector<DatabaseMapping> mappings = descriptor.getMappings();
                int size = mappings.size();
                for (int index = 0; index < size; ++index) {
                    DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
                    if (fetchGroup != null && !fetchGroup.containsAttributeInternal(mapping.getAttributeName())) continue;
                    changes.addChange(mapping.compareForChange(clone, null, changes, session));
                }
            }
        }
        if (descriptor.usesOptimisticLocking() && changes.getId() != null) {
            changes.setOptimisticLockingPolicyAndInitialWriteLockValue(descriptor.getOptimisticLockingPolicy(), session);
        }
        return changes;
    }

    public boolean isAttributeChangeTrackingPolicy() {
        return true;
    }

    public void updateWithChanges(Object object, ObjectChangeSet changeSet, UnitOfWorkImpl uow, ClassDescriptor descriptor) {
        this.clearChanges(object, uow, descriptor, false);
    }

    public void revertChanges(Object clone, ClassDescriptor descriptor, UnitOfWorkImpl uow, Map cloneMapping, boolean forRefresh) {
        this.clearChanges(clone, uow, descriptor, forRefresh);
        cloneMapping.put(clone, clone);
    }

    public void setAggregateChangeListener(Object parent, Object aggregate, UnitOfWorkImpl uow, ClassDescriptor descriptor, String mappingAttribute) {
        ((ChangeTracker)aggregate)._persistence_setPropertyChangeListener(new AggregateAttributeChangeListener(descriptor, uow, (AttributeChangeListener)((ChangeTracker)parent)._persistence_getPropertyChangeListener(), mappingAttribute, aggregate));
        for (DatabaseMapping mapping : descriptor.getMappings()) {
            AggregateObjectMapping aggregateMapping;
            Object nestedAggregate;
            if (!mapping.isAggregateObjectMapping() || (nestedAggregate = (aggregateMapping = (AggregateObjectMapping)mapping).getAttributeValueFromObject(aggregate)) == null || !(nestedAggregate instanceof ChangeTracker)) continue;
            descriptor.getObjectChangePolicy().setAggregateChangeListener(aggregate, nestedAggregate, uow, aggregateMapping.getReferenceDescriptor(), aggregateMapping.getAttributeName());
        }
    }

    public PropertyChangeListener setChangeListener(Object clone, UnitOfWorkImpl uow, ClassDescriptor descriptor) {
        AttributeChangeListener listener = new AttributeChangeListener(descriptor, uow, clone);
        ((ChangeTracker)clone)._persistence_setPropertyChangeListener(listener);
        return listener;
    }

    public void setChangeSetOnListener(ObjectChangeSet objectChangeSet, Object clone) {
        ((AttributeChangeListener)((ChangeTracker)clone)._persistence_getPropertyChangeListener()).setObjectChangeSet(objectChangeSet);
    }

    public Object buildBackupClone(Object clone, ObjectBuilder builder, UnitOfWorkImpl uow) {
        return clone;
    }
}

