/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.mappings.XMLAnyAttributeMapping;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;

public class XMLAnyAttributeMappingNodeValue
extends MappingNodeValue
implements ContainerValue {
    private XMLAnyAttributeMapping xmlAnyAttributeMapping;
    private int index = -1;

    public XMLAnyAttributeMappingNodeValue(XMLAnyAttributeMapping xmlAnyAttributeMapping) {
        this.xmlAnyAttributeMapping = xmlAnyAttributeMapping;
    }

    public boolean isOwningNode(XPathFragment xPathFragment) {
        return xPathFragment == null;
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        Object iter;
        if (this.xmlAnyAttributeMapping.isReadOnly()) {
            return false;
        }
        Object collection = this.xmlAnyAttributeMapping.getAttributeValueFromObject(object);
        if (collection == null) {
            return false;
        }
        MappedKeyMapContainerPolicy cp = this.getContainerPolicy();
        if (!((ContainerPolicy)cp).hasNext(iter = ((ContainerPolicy)cp).iteratorFor(collection))) {
            return false;
        }
        XPathFragment groupingElements = marshalRecord.openStartGroupingElements(namespaceResolver);
        ArrayList<String> extraNamespaces = new ArrayList<String>();
        NamespaceResolver nr = marshalRecord.getNamespaceResolver();
        while (((ContainerPolicy)cp).hasNext(iter)) {
            Map.Entry entry = (Map.Entry)((ContainerPolicy)cp).nextEntry(iter, session);
            Object key = entry.getKey();
            if (!(key instanceof QName)) continue;
            QName name = (QName)key;
            String value = entry.getValue().toString();
            String qualifiedName = name.getLocalPart();
            if (nr != null) {
                String prefix = nr.resolveNamespaceURI(name.getNamespaceURI());
                if (prefix != null && prefix.length() > 0) {
                    qualifiedName = prefix + ':' + qualifiedName;
                } else if (name.getNamespaceURI() != null && name.getNamespaceURI().length() > 0) {
                    String customPrefix;
                    String generatedPrefix = nr.generatePrefix();
                    if (marshalRecord.hasCustomNamespaceMapper() && (customPrefix = marshalRecord.getMarshaller().getNamespacePrefixMapper().getPreferredPrefix(name.getNamespaceURI(), generatedPrefix, true)) != null && customPrefix.length() > 0) {
                        generatedPrefix = customPrefix;
                    }
                    qualifiedName = generatedPrefix + ':' + qualifiedName;
                    nr.put(generatedPrefix, name.getNamespaceURI());
                    extraNamespaces.add(generatedPrefix);
                    marshalRecord.attribute("http://www.w3.org/2000/xmlns/", generatedPrefix, "xmlns:" + generatedPrefix, name.getNamespaceURI());
                }
            }
            marshalRecord.attribute(name.getNamespaceURI(), name.getLocalPart(), qualifiedName, value);
        }
        for (int i = 0; i < extraNamespaces.size(); ++i) {
            marshalRecord.getNamespaceResolver().removeNamespace((String)extraNamespaces.get(i));
        }
        marshalRecord.closeStartGroupingElements(groupingElements);
        return true;
    }

    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value) {
        boolean includeAttribute = true;
        if (!this.xmlAnyAttributeMapping.isNamespaceDeclarationIncluded() && "http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            includeAttribute = false;
        } else if (!this.xmlAnyAttributeMapping.isSchemaInstanceIncluded() && "http://www.w3.org/2001/XMLSchema-instance".equals(namespaceURI)) {
            includeAttribute = false;
        }
        if (includeAttribute) {
            ContainerPolicy cp = this.xmlAnyAttributeMapping.getContainerPolicy();
            Object containerInstance = unmarshalRecord.getContainerInstance(this);
            QName key = new QName(namespaceURI, localName);
            cp.addInto(key, value, containerInstance, unmarshalRecord.getSession());
        }
    }

    public Object getContainerInstance() {
        return this.xmlAnyAttributeMapping.getContainerPolicy().containerInstance();
    }

    public void setContainerInstance(Object object, Object container) {
        this.xmlAnyAttributeMapping.setAttributeValueInObject(object, container);
    }

    public MappedKeyMapContainerPolicy getContainerPolicy() {
        return (MappedKeyMapContainerPolicy)this.xmlAnyAttributeMapping.getContainerPolicy();
    }

    public boolean isContainerValue() {
        return true;
    }

    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        return true;
    }

    public XMLAnyAttributeMapping getMapping() {
        return this.xmlAnyAttributeMapping;
    }

    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isDefaultEmptyContainer() {
        return this.getMapping().isDefaultEmptyContainer();
    }
}

