/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.StringWriter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.DoubleConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.FieldRefConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.FloatConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.IntegerConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.InterfaceMethodRefConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.LongConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.MethodRefConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.NameAndTypeConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.StringConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.UTF8Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class ConstantPool {
    private short count;
    private Constant[] constants;

    ConstantPool(ClassFileDataInputStream stream) throws IOException {
        this.initialize(stream);
    }

    private void initialize(ClassFileDataInputStream stream) throws IOException {
        short cnt = this.count = stream.readU2();
        Constant[] localConstants = this.constants = new Constant[cnt];
        localConstants[0] = Constant.nullConstant(this, stream);
        for (short i = 1; i < cnt; i = (short)(i + 1)) {
            Constant constant;
            localConstants[i] = constant = Constant.buildConstant(this, stream);
            if (!constant.consumesTwoPoolEntries()) continue;
            i = (short)(i + 1);
            localConstants[i] = Constant.nullConstant(this, stream);
        }
    }

    public String displayString() {
        StringWriter sw = new StringWriter(1000);
        IndentingPrintWriter writer = new IndentingPrintWriter(sw);
        this.displayStringOn(writer);
        return sw.toString();
    }

    public void displayStringOn(IndentingPrintWriter writer) {
        short cnt = this.count;
        Constant[] localConstants = this.constants;
        writer.print("Constant Pool (count: ");
        writer.print(cnt);
        writer.println(')');
        writer.indent();
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            writer.print(i);
            writer.print(": ");
            localConstants[i].displayStringOn(writer);
        }
        writer.undent();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        short cnt = this.count;
        Constant[] localConstants = this.constants;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            localConstants[i].accept(visitor);
        }
    }

    public short getCount() {
        return this.count;
    }

    public Constant get(short index) {
        return this.constants[index];
    }

    public ClassConstant getClassConstant(short index) {
        return (ClassConstant)this.constants[index];
    }

    public DoubleConstant getDoubleConstant(short index) {
        return (DoubleConstant)this.constants[index];
    }

    public FloatConstant getFloatConstant(short index) {
        return (FloatConstant)this.constants[index];
    }

    public IntegerConstant getIntegerConstant(short index) {
        return (IntegerConstant)this.constants[index];
    }

    public LongConstant getLongConstant(short index) {
        return (LongConstant)this.constants[index];
    }

    public NameAndTypeConstant getNameAndTypeConstant(short index) {
        return (NameAndTypeConstant)this.constants[index];
    }

    public FieldRefConstant getFieldRefConstant(short index) {
        return (FieldRefConstant)this.constants[index];
    }

    public InterfaceMethodRefConstant getInterfaceMethodRefConstant(short index) {
        return (InterfaceMethodRefConstant)this.constants[index];
    }

    public MethodRefConstant getMethodRefConstant(short index) {
        return (MethodRefConstant)this.constants[index];
    }

    public StringConstant getStringConstant(short index) {
        return (StringConstant)this.constants[index];
    }

    public UTF8Constant getUTF8Constant(short index) {
        return (UTF8Constant)this.constants[index];
    }

    public String getUTF8String(short index) {
        return this.getUTF8Constant(index).string();
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.count + " constant(s))";
    }
}

