/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.utility.diff.ContainerDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;

public class UnorderedArrayAdapter
implements ContainerDifferentiator.Adapter {
    private static UnorderedArrayAdapter INSTANCE;

    public static synchronized UnorderedArrayAdapter instance() {
        if (INSTANCE == null) {
            INSTANCE = new UnorderedArrayAdapter();
        }
        return INSTANCE;
    }

    protected UnorderedArrayAdapter() {
    }

    @Override
    public boolean diffIsFatal(Object object1, Object object2) {
        if (object1 == null || !object1.getClass().isArray()) {
            return true;
        }
        return object2 == null || !object2.getClass().isArray();
    }

    @Override
    public Class containerClass() {
        return Array.class;
    }

    @Override
    public int size(Object container) {
        return ((Object[])container).length;
    }

    @Override
    public Iterator iterator(Object container) {
        return new ArrayIterator((Object[])container);
    }

    public String toString() {
        return "UnorderedArrayAdapter";
    }
}

