/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform;

import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPropertiesPage;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformsApplicationNode;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformsPlugin;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform.AddDatabaseTypeAction;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform.CloneDatabasePlatformAction;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform.DatabasePlatformTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform.DeleteDatabasePlatformAction;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform.RenameDatabasePlatformAction;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.repository.DatabasePlatformRepositoryNode;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.type.DatabaseTypeNode;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.node.NodeModel;

public final class DatabasePlatformNode
extends PlatformsApplicationNode {
    private ListValueModel childrenModel;
    protected static final String[] DATABASE_PLATFORM_DISPLAY_STRING_PROPERTY_NAMES = new String[]{"name"};

    public DatabasePlatformNode(DatabasePlatform platform, DatabasePlatformRepositoryNode parent, PlatformsPlugin plugin, ApplicationContext context) {
        super((NodeModel)platform, parent, plugin, context);
    }

    protected void initialize() {
        super.initialize();
        this.childrenModel = this.buildChildrenModel();
    }

    private ListValueModel buildChildrenModel() {
        return new SortedListValueModelAdapter(this.buildDisplayStringAdapter());
    }

    private ListValueModel buildDisplayStringAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildDatabaseTypeNodeAdapter(), "displayString");
    }

    private ListValueModel buildDatabaseTypeNodeAdapter() {
        return new TransformationListValueModelAdapter(this.buildDatabaseTypesAdapter()){

            @Override
            protected Object transformItem(Object item) {
                return DatabasePlatformNode.this.buildDatabaseTypeNode((DatabaseType)item);
            }
        };
    }

    DatabaseTypeNode buildDatabaseTypeNode(DatabaseType databaseType) {
        return new DatabaseTypeNode(databaseType, this, this.getPlatformsPlugin(), this.getApplicationContext());
    }

    private CollectionValueModel buildDatabaseTypesAdapter() {
        return new CollectionAspectAdapter(this, "databaseTypes"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((DatabasePlatform)this.subject).databaseTypes();
            }

            @Override
            protected int sizeFromSubject() {
                return ((DatabasePlatform)this.subject).databaseTypesSize();
            }
        };
    }

    @Override
    protected Class propertiesPageClass() {
        return DatabasePlatformTabbedPropertiesPage.class;
    }

    @Override
    protected AbstractPropertiesPage buildPropertiesPage(WorkbenchContext context) {
        return new DatabasePlatformTabbedPropertiesPage(context);
    }

    @Override
    public String helpTopicID() {
        return "database.platform";
    }

    @Override
    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    @Override
    protected String[] displayStringPropertyNames() {
        return DATABASE_PLATFORM_DISPLAY_STRING_PROPERTY_NAMES;
    }

    @Override
    protected String buildIconKey() {
        return "DATABASE_PLATFORM";
    }

    @Override
    public GroupContainerDescription buildMenuDescription(WorkbenchContext context) {
        context = this.buildLocalWorkbenchContext(context);
        RootMenuDescription menu = new RootMenuDescription();
        MenuGroupDescription basicGroup = new MenuGroupDescription();
        basicGroup.add(this.buildRenameAction(context));
        basicGroup.add(this.buildDeleteAction(context));
        basicGroup.add(this.buildCloneAction(context));
        basicGroup.add(this.buildAddTypeAction(context));
        menu.add(basicGroup);
        MenuGroupDescription helpGroup = new MenuGroupDescription();
        helpGroup.add(this.getPlatformsPlugin().getHelpAction(context));
        menu.add(helpGroup);
        return menu;
    }

    @Override
    public GroupContainerDescription buildToolBarDescription(WorkbenchContext context) {
        context = this.buildLocalWorkbenchContext(context);
        ToolBarDescription toolBar = new ToolBarDescription();
        ToolBarButtonGroupDescription basicGroup = new ToolBarButtonGroupDescription();
        basicGroup.add(this.buildRenameAction(context));
        basicGroup.add(this.buildDeleteAction(context));
        basicGroup.add(this.buildCloneAction(context));
        basicGroup.add(this.buildAddTypeAction(context));
        toolBar.add(basicGroup);
        return toolBar;
    }

    DatabasePlatform getDatabasePlatform() {
        return (DatabasePlatform)this.getValue();
    }

    private FrameworkAction buildRenameAction(WorkbenchContext context) {
        return new RenameDatabasePlatformAction(context);
    }

    private FrameworkAction buildDeleteAction(WorkbenchContext context) {
        return new DeleteDatabasePlatformAction(context);
    }

    private FrameworkAction buildCloneAction(WorkbenchContext context) {
        return new CloneDatabasePlatformAction(context);
    }

    private FrameworkAction buildAddTypeAction(WorkbenchContext context) {
        return new AddDatabaseTypeAction(context);
    }
}

