/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.transaction;

import javax.persistence.EntityTransaction;
import javax.persistence.RollbackException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.TransactionException;
import org.eclipse.persistence.internal.jpa.transaction.EntityTransactionWrapper;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

public class EntityTransactionImpl
implements EntityTransaction {
    protected EntityTransactionWrapper wrapper;
    protected boolean active = false;
    protected boolean rollbackOnly = false;

    public EntityTransactionImpl(EntityTransactionWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public void begin() {
        if (this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionIsActive().getMessage());
        }
        this.wrapper.localUOW = this.wrapper.getEntityManager().getActivePersistenceContext(null);
        this.wrapper.localUOW.setShouldTerminateTransaction(false);
        this.active = true;
    }

    public void commit() {
        try {
            this.commitInternal();
        }
        catch (EclipseLinkException tlException) {
            throw new RollbackException((Throwable)tlException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void commitInternal() {
        if (!this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionNotActive().getMessage());
        }
        try {
            if (this.wrapper.localUOW == null) return;
            this.wrapper.localUOW.setShouldTerminateTransaction(true);
            if (this.rollbackOnly) throw new RollbackException(ExceptionLocalization.buildMessage("rollback_because_of_rollback_only"));
            if (this.wrapper.localUOW.shouldResumeUnitOfWorkOnTransactionCompletion()) {
                this.wrapper.localUOW.commitAndResume();
                return;
            }
            try {
                this.wrapper.localUOW.commit();
                this.wrapper.localUOW.clearForClose(false);
                return;
            }
            catch (RuntimeException ex) {
                if (this.wrapper.localUOW != null) {
                    this.wrapper.getEntityManager().removeExtendedPersistenceContext();
                    this.wrapper.localUOW.release();
                    this.wrapper.localUOW.getParent().release();
                }
                if (this.rollbackOnly) throw ex;
                throw new RollbackException((Throwable)ex);
            }
        }
        finally {
            this.active = false;
            this.rollbackOnly = false;
            this.wrapper.setLocalUnitOfWork(null);
        }
    }

    public void rollback() {
        if (!this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionNotActive().getMessage());
        }
        try {
            if (this.wrapper.getLocalUnitOfWork() != null) {
                this.wrapper.localUOW.setShouldTerminateTransaction(true);
                this.wrapper.localUOW.release();
                this.wrapper.localUOW.getParent().release();
            }
        }
        finally {
            this.active = false;
            this.rollbackOnly = false;
            this.wrapper.getEntityManager().removeExtendedPersistenceContext();
            this.wrapper.setLocalUnitOfWork(null);
        }
    }

    public void setRollbackOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionNotActive().getMessage());
        }
        this.rollbackOnly = true;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.isActive()) {
                this.rollback();
            }
        }
        finally {
            super.finalize();
        }
    }

    public boolean getRollbackOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionNotActive().getMessage());
        }
        return this.rollbackOnly;
    }

    public boolean isActive() {
        return this.active;
    }
}

