/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import java.io.IOException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.tests.clientserver.DeadLockEmployee;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class ConcurrentTestWithReadLocks
extends AutoVerifyTestCase {
    public static int numThreads = 8;
    public boolean isCheckerThread;
    public static Server server;
    public static boolean execute;
    public static Thread[] threadList;
    public static long[] timeList;
    public static long runTime;
    public int index;

    public ConcurrentTestWithReadLocks(long runtime) {
        this.setDescription("Test Simulates a highly concurrent situation with ReadLocks");
        runTime = runtime;
    }

    protected ConcurrentTestWithReadLocks(boolean checkerThread, int index) {
        this.isCheckerThread = checkerThread;
        this.index = index;
    }

    public void reset() {
        execute = false;
        for (int count = 0; count < numThreads; ++count) {
            try {
                threadList[count].join();
                continue;
            }
            catch (InterruptedException ex) {
                throw new TestProblemException("Test thread was interrupted.  Test failed to run properly");
            }
        }
        server.logout();
    }

    public void setup() {
        execute = true;
        try {
            this.getSession().getLog().write("WARNING, some tests may take 3 minutes or more");
            this.getSession().getLog().flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            DatabaseLogin login = (DatabaseLogin)this.getSession().getLogin().clone();
            server = new Server(login, numThreads, numThreads + 2);
            ConcurrentTestWithReadLocks.server.serverSession.setSessionLog(this.getSession().getSessionLog());
            server.login();
            server.copyDescriptors(this.getSession());
        }
        catch (ValidationException ex) {
            this.verify();
        }
        for (int count = 0; count < numThreads; ++count) {
            ConcurrentTestWithReadLocks.threadList[count] = new Thread(new ConcurrentTestWithReadLocks(false, count).runnable());
            ConcurrentTestWithReadLocks.timeList[count] = System.currentTimeMillis();
        }
    }

    public void test() {
        for (int count = 0; count < numThreads; ++count) {
            threadList[count].start();
        }
        Thread checker = new Thread(new ConcurrentTestWithReadLocks(true, -1).runnable());
        checker.start();
        try {
            checker.join();
        }
        catch (InterruptedException ex) {
            throw new TestProblemException("Test thread was interrupted.  Test failed to run properly");
        }
    }

    public void verify() {
        if (!execute) {
            for (int count = 0; count < numThreads; ++count) {
                threadList[count].stop();
            }
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            throw new TestErrorException("This test caused a deadlock in TopLink.  see bug 3049635");
        }
    }

    public Runnable runnable() {
        return new Runnable(){

            @Override
            public void run() {
                if (ConcurrentTestWithReadLocks.this.isCheckerThread) {
                    ConcurrentTestWithReadLocks.this.watchOtherThreads();
                } else {
                    ConcurrentTestWithReadLocks.this.executeUntilStopped();
                }
            }
        };
    }

    public void watchOtherThreads() {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < runTime + 30000L && execute) {
            for (int localIdex = 0; localIdex < numThreads; ++localIdex) {
                if (System.currentTimeMillis() - timeList[localIdex] <= 30000L) continue;
                execute = false;
                break;
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex) {
                throw new TestProblemException("Test thread was interrupted.  Test failed to run properly");
            }
        }
    }

    public void executeUntilStopped() {
        ClientSession session = ConcurrentTestWithReadLocks.server.serverSession.acquireClientSession();
        DeadLockEmployee employee = (DeadLockEmployee)session.readObject(DeadLockEmployee.class);
        while (execute) {
            ConcurrentTestWithReadLocks.timeList[this.index] = System.currentTimeMillis();
            UnitOfWork uow = session.acquireUnitOfWork();
            DeadLockEmployee workingEmp = (DeadLockEmployee)uow.registerObject((Object)employee);
            uow.refreshObject((Object)workingEmp);
            uow.commit();
        }
    }

    static {
        execute = true;
        threadList = new Thread[numThreads];
        timeList = new long[numThreads];
    }
}

