/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.proxyindirection;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.proxyindirection.Address;
import org.eclipse.persistence.testing.tests.proxyindirection.Employee;

public class ReadProxyObjectTest
extends AutoVerifyTestCase {
    Address address;

    public ReadProxyObjectTest() {
        this.setDescription("Tests ReadObject on a proxy object using Proxy Indirection.");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
    }

    public void test() {
        Employee emp = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").like("Rick%"));
        ReadObjectQuery read = new ReadObjectQuery((Object)emp.getAddress());
        this.address = (Address)this.getSession().executeQuery((DatabaseQuery)read);
    }

    public void verify() {
        if (this.address == null) {
            throw new TestErrorException("No address was returned");
        }
        if (!this.address.getStreet().equals("509-171 Lees Ave.")) {
            throw new TestErrorException("The wrong address was returned: " + this.address.getStreet() + ".  It should be: 509-171 Lees Ave.");
        }
    }
}

