/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic.simple.mappings;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicTypeBuilder;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.testing.tests.jpa.dynamic.DynamicTestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class SimpleTypes_MultiTable {
    static EntityManagerFactory emf = null;
    static JPADynamicHelper helper = null;

    @BeforeClass
    public static void setUp() {
        emf = DynamicTestHelper.createEMF("dynamic");
        boolean isMySQL = JpaHelper.getServerSession((EntityManagerFactory)emf).getDatasourcePlatform().getClass().getName().contains("MySQLPlatform");
        Assume.assumeTrue((boolean)isMySQL);
        helper = new JPADynamicHelper(emf);
        DynamicClassLoader dcl = helper.getDynamicClassLoader();
        Class simpleTypeA = dcl.createDynamicClass("model.SimpleA");
        JPADynamicTypeBuilder typeBuilder = new JPADynamicTypeBuilder(simpleTypeA, null, new String[]{"SIMPLE_TYPE_A", "SIMPLE_TYPE_B", "SIMPLE_TYPE_C"});
        typeBuilder.setPrimaryKeyFields(new String[]{"SIMPLE_TYPE_A.SID"});
        typeBuilder.addDirectMapping("id", Integer.TYPE, "SIMPLE_TYPE_A.SID");
        typeBuilder.addDirectMapping("value1", String.class, "SIMPLE_TYPE_A.VAL_1");
        typeBuilder.addDirectMapping("value2", Boolean.TYPE, "SIMPLE_TYPE_B.VAL_2");
        typeBuilder.addDirectMapping("value3", String.class, "SIMPLE_TYPE_B.VAL_3");
        typeBuilder.addDirectMapping("value4", Double.TYPE, "SIMPLE_TYPE_C.VAL_4");
        typeBuilder.addDirectMapping("value5", String.class, "SIMPLE_TYPE_C.VAL_5");
        helper.addTypes(true, true, new DynamicType[]{typeBuilder.getType()});
    }

    @AfterClass
    public static void shutdown() {
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        em.createNativeQuery("DROP TABLE SIMPLE_TYPE_C").executeUpdate();
        em.createNativeQuery("DROP TABLE SIMPLE_TYPE_B").executeUpdate();
        em.createNativeQuery("DROP TABLE SIMPLE_TYPE_A").executeUpdate();
        em.getTransaction().commit();
        em.close();
        emf.close();
    }

    @After
    public void clearDynamicTables() {
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        em.createQuery("DELETE FROM SimpleA").executeUpdate();
        em.getTransaction().commit();
        em.close();
    }

    @Test
    public void verifyConfig() throws Exception {
        ClassDescriptor descriptorA = helper.getSession().getClassDescriptorForAlias("SimpleA");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleA'", (Object)descriptorA);
        DynamicType simpleTypeA = helper.getType("SimpleA");
        Assert.assertNotNull((String)"'SimpleA' EntityType not found", (Object)simpleTypeA);
        Assert.assertEquals((Object)descriptorA, (Object)simpleTypeA.getDescriptor());
        Assert.assertTrue((boolean)descriptorA.hasMultipleTables());
        Assert.assertEquals((long)3L, (long)descriptorA.getTables().size());
        DirectToFieldMapping a_id = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("id");
        Assert.assertEquals(Integer.TYPE, (Object)a_id.getAttributeClassification());
        DirectToFieldMapping a_value1 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value1");
        Assert.assertEquals(String.class, (Object)a_value1.getAttributeClassification());
        DirectToFieldMapping a_value2 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value2");
        Assert.assertEquals(Boolean.TYPE, (Object)a_value2.getAttributeClassification());
        DirectToFieldMapping a_value3 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value3");
        Assert.assertEquals(String.class, (Object)a_value3.getAttributeClassification());
        DirectToFieldMapping a_value4 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value4");
        Assert.assertEquals(Double.TYPE, (Object)a_value4.getAttributeClassification());
        DirectToFieldMapping a_value5 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value5");
        Assert.assertEquals(String.class, (Object)a_value5.getAttributeClassification());
    }

    @Test
    public void verifyProperties() {
        DynamicType simpleTypeA = helper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        Assert.assertEquals((long)6L, (long)simpleTypeA.getNumberOfProperties());
        Assert.assertTrue((boolean)simpleTypeA.getPropertiesNames().contains("id"));
        Assert.assertEquals(Integer.TYPE, (Object)simpleTypeA.getPropertyType("id"));
        Assert.assertTrue((String)"value1", (boolean)simpleTypeA.getPropertiesNames().contains("value1"));
        Assert.assertEquals(String.class, (Object)simpleTypeA.getPropertyType("value1"));
        Assert.assertTrue((String)"value2", (boolean)simpleTypeA.getPropertiesNames().contains("value2"));
        Assert.assertEquals(Boolean.TYPE, (Object)simpleTypeA.getPropertyType("value2"));
        Assert.assertTrue((String)"value3", (boolean)simpleTypeA.getPropertiesNames().contains("value3"));
        Assert.assertEquals(String.class, (Object)simpleTypeA.getPropertyType("value3"));
        Assert.assertTrue((String)"value4", (boolean)simpleTypeA.getPropertiesNames().contains("value4"));
        Assert.assertEquals(Double.TYPE, (Object)simpleTypeA.getPropertyType("value4"));
        Assert.assertTrue((String)"value5", (boolean)simpleTypeA.getPropertiesNames().contains("value5"));
        Assert.assertEquals(String.class, (Object)simpleTypeA.getPropertyType("value5"));
    }

    @Test
    public void createSimpleA() {
        DynamicType simpleTypeA = helper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        DynamicEntity a = simpleTypeA.newDynamicEntity();
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)a.get("id"), (Object)0);
        Assert.assertFalse((boolean)a.isSet("value1"));
        Assert.assertEquals((Object)a.get("value2"), (Object)false);
        Assert.assertFalse((boolean)a.isSet("value3"));
        Assert.assertEquals((Object)a.get("value4"), (Object)0.0);
        Assert.assertFalse((boolean)a.isSet("value5"));
    }

    @Test
    public void persistSimpleA() {
        DynamicType simpleTypeA = helper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        EntityManager em = emf.createEntityManager();
        DynamicEntity simpleInstance = simpleTypeA.newDynamicEntity();
        simpleInstance.set("id", (Object)1);
        simpleInstance.set("value1", (Object)"A1");
        em.getTransaction().begin();
        em.persist((Object)simpleInstance);
        em.getTransaction().commit();
        int simpleCount = ((Number)em.createQuery("SELECT COUNT(s) FROM SimpleA s").getSingleResult()).intValue();
        Assert.assertEquals((long)1L, (long)simpleCount);
        em.close();
    }

    @Test
    public void verifyChangeTracking() {
        this.persistSimpleA();
        DynamicType simpleTypeA = helper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        DynamicEntityImpl a = (DynamicEntityImpl)em.find(simpleTypeA.getJavaClass(), (Object)1);
        Assert.assertNotNull((Object)a);
        Assert.assertNotNull((Object)a._persistence_getPropertyChangeListener());
        em.getTransaction().rollback();
        em.close();
    }
}

