/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.opti.AttrImpl;
import org.apache.xerces.impl.xs.opti.ElementImpl;
import org.apache.xerces.impl.xs.opti.SchemaDOM;
import org.apache.xerces.impl.xs.opti.SchemaDOMParser;
import org.apache.xerces.impl.xs.opti.SchemaParsingConfig;
import org.apache.xerces.util.URI;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSException;
import org.apache.xerces.xs.XSModel;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaClassPathReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaFileReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaURLReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNominative;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.QName;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWXmlProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ClasspathResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.FileResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.UrlResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroup;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroupDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchemaRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;
import org.w3c.dom.NamedNodeMap;

public final class MWXmlSchema
extends MWModel
implements MWNominative {
    public static final int INFINITY = 0x7FFFFFF8;
    private boolean shouldUseDefaultNamespace;
    public static final String SHOULD_USE_DEFAULT_NAMESPACE = "shouldUseDefaultNamespace";
    private String defaultNamespaceUrl;
    public static final String DEFAULT_NAMESPACE_URL = "defaultNamespaceUrl";
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private volatile ResourceSpecification schemaSource;
    public static final String SCHEMA_SOURCE_PROPERTY = "schemaSource";
    private volatile String targetNamespaceUrl;
    private Collection declaredNamespaces;
    public static final String NAMESPACES_COLLECTION = "namespaces";
    private List builtInNamespaces;

    public static MWXmlSchema createFromFile(MWXmlSchemaRepository parent, String name, String filePath) {
        MWXmlSchema schema = new MWXmlSchema(parent, name);
        schema.setSchemaSource(new FileResourceSpecification(schema, filePath));
        return schema;
    }

    public static MWXmlSchema createFromUrl(MWXmlSchemaRepository parent, String name, String url) {
        MWXmlSchema schema = new MWXmlSchema(parent, name);
        schema.setSchemaSource(new UrlResourceSpecification(schema, url));
        return schema;
    }

    public static MWXmlSchema createFromClasspath(MWXmlSchemaRepository parent, String name, String resourceName) {
        MWXmlSchema schema = new MWXmlSchema(parent, name);
        schema.setSchemaSource(new ClasspathResourceSpecification(schema, resourceName));
        return schema;
    }

    private MWXmlSchema() {
    }

    private MWXmlSchema(MWModel parent) {
        super(parent);
    }

    private MWXmlSchema(MWModel parent, String name) {
        this(parent);
        this.initialize(name);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeBuiltInNamespaces();
    }

    private void initializeBuiltInNamespaces() {
        this.builtInNamespaces = new Vector();
        this.builtInNamespaces.add(MWNamespace.xsdNamespace(this));
        this.builtInNamespaces.add(MWNamespace.xsiNamespace(this));
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.targetNamespaceUrl = "";
        this.defaultNamespaceUrl = "";
        this.shouldUseDefaultNamespace = false;
        this.declaredNamespaces = new HashBag();
    }

    private void initialize(String schemaName) {
        this.name = schemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.schemaSource);
        Collection collection = this.declaredNamespaces;
        synchronized (collection) {
            children.addAll(this.declaredNamespaces);
        }
        collection = this.builtInNamespaces;
        synchronized (collection) {
            children.addAll(this.builtInNamespaces);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        String old = this.name;
        this.name = name;
        if (this.attributeValueHasChanged(old, name)) {
            try {
                this.schemaRepository().schemaRenamed(old, name, this);
            }
            catch (RuntimeException ex) {
                this.name = old;
                throw ex;
            }
            this.firePropertyChanged(NAME_PROPERTY, old, name);
            this.getProject().nodeRenamed(this);
        }
    }

    public ResourceSpecification getSchemaSource() {
        return this.schemaSource;
    }

    private void setSchemaSource(ResourceSpecification newSchemaSource) {
        ResourceSpecification oldSchemaLocation = this.schemaSource;
        this.schemaSource = newSchemaSource;
        this.firePropertyChanged(SCHEMA_SOURCE_PROPERTY, oldSchemaLocation, newSchemaSource);
    }

    public void setFileSchemaLocation(String filePath) {
        this.setSchemaSource(new FileResourceSpecification(this, filePath));
    }

    public void setUrlSchemaLocation(String url) {
        this.setSchemaSource(new UrlResourceSpecification(this, url));
    }

    public void setClasspathSchemaLocation(String resourceName) {
        this.setSchemaSource(new ClasspathResourceSpecification(this, resourceName));
    }

    public String targetNamespaceUrl() {
        return this.targetNamespaceUrl;
    }

    public void setTargetNamespaceUrl(String newTargetNamespaceUrl) {
        this.targetNamespaceUrl = newTargetNamespaceUrl;
        if ("".equals(this.defaultNamespaceUrl)) {
            this.defaultNamespaceUrl = this.targetNamespaceUrl;
        }
    }

    public Iterator declaredNamespaces() {
        return this.declaredNamespaces.iterator();
    }

    private MWNamespace declaredNamespace(String namespaceUrl) {
        Iterator stream = this.declaredNamespaces();
        while (stream.hasNext()) {
            MWNamespace next = (MWNamespace)stream.next();
            if (!next.getNamespaceUrl().equals(namespaceUrl)) continue;
            return next;
        }
        return null;
    }

    private MWNamespace addDeclaredNamespace(String namespaceUrl) {
        MWNamespace namespace = new MWNamespace(this);
        this.addDeclaredNamespace(namespace);
        return namespace;
    }

    private void addDeclaredNamespace(MWNamespace namespace) {
        this.declaredNamespaces.add(namespace);
        this.fireItemAdded(NAMESPACES_COLLECTION, namespace);
    }

    private void removeDeclaredNamespace(MWNamespace namespace) {
        this.declaredNamespaces.remove(namespace);
        this.fireItemRemoved(NAMESPACES_COLLECTION, namespace);
        this.getProject().nodeRemoved(namespace);
    }

    public MWNamespace targetNamespace() {
        return this.declaredNamespace(this.targetNamespaceUrl());
    }

    public Iterator importedNamespaces() {
        return new FilteringIterator(this.declaredNamespaces()){

            @Override
            protected boolean accept(Object next) {
                return !((MWNamespace)next).isTargetNamespace();
            }
        };
    }

    public ListIterator builtInNamespaces() {
        return this.builtInNamespaces.listIterator();
    }

    private MWNamespace builtInNamespace(String namespaceUrl) {
        ListIterator stream = this.builtInNamespaces();
        while (stream.hasNext()) {
            MWNamespace next = (MWNamespace)stream.next();
            if (!next.getNamespaceUrl().equals(namespaceUrl)) continue;
            return next;
        }
        return null;
    }

    public MWXmlSchemaRepository schemaRepository() {
        return (MWXmlSchemaRepository)this.getParent();
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.name);
    }

    private Iterator namespaces() {
        return new CompositeIterator(this.declaredNamespaces(), (Iterator)this.builtInNamespaces());
    }

    public String namespaceUrlForPrefix(String namespacePrefix) {
        Iterator stream = this.namespaces();
        while (stream.hasNext()) {
            MWNamespace namespace = (MWNamespace)stream.next();
            if (!namespacePrefix.equals(namespace.getNamespacePrefix())) continue;
            return namespace.getNamespaceUrl();
        }
        return "";
    }

    public String namespacePrefixForUrl(String namespaceUrl) {
        if (namespaceUrl == null || "".equals(namespaceUrl)) {
            return "";
        }
        return this.namespaceForUrl(namespaceUrl).getNamespacePrefix();
    }

    public MWNamespace namespaceForUrl(String namespaceUrl) {
        Iterator stream = this.namespaces();
        while (stream.hasNext()) {
            MWNamespace next = (MWNamespace)stream.next();
            if (!next.getNamespaceUrl().equals(namespaceUrl)) continue;
            return next;
        }
        return null;
    }

    public int attributeCount() {
        int attributeCount = 0;
        Iterator stream = this.declaredNamespaces();
        while (stream.hasNext()) {
            attributeCount += ((MWNamespace)stream.next()).attributeCount();
        }
        return attributeCount;
    }

    public MWAttributeDeclaration attribute(String attributeName) {
        return this.attribute(this.targetNamespaceUrl, attributeName);
    }

    public MWAttributeDeclaration attribute(String namespaceUrl, String attributeName) {
        if (namespaceUrl == null || "".equals(namespaceUrl)) {
            namespaceUrl = this.targetNamespaceUrl();
        }
        return this.namespaceForUrl(namespaceUrl).attribute(attributeName);
    }

    public int elementCount() {
        int elementCount = 0;
        Iterator stream = this.declaredNamespaces();
        while (stream.hasNext()) {
            elementCount += ((MWNamespace)stream.next()).elementCount();
        }
        return elementCount;
    }

    public MWElementDeclaration element(String elementName) {
        return this.element(this.targetNamespaceUrl, elementName);
    }

    public MWElementDeclaration element(String namespaceUrl, String elementName) {
        if (namespaceUrl == null || "".equals(namespaceUrl)) {
            namespaceUrl = this.targetNamespaceUrl();
        }
        return this.namespaceForUrl(namespaceUrl).element(elementName);
    }

    public int typeCount() {
        int typeCount = 0;
        Iterator stream = this.declaredNamespaces();
        while (stream.hasNext()) {
            typeCount += ((MWNamespace)stream.next()).typeCount();
        }
        return typeCount;
    }

    public MWComplexTypeDefinition complexType(String complexTypeName) {
        return this.complexType(this.targetNamespaceUrl, complexTypeName);
    }

    public MWComplexTypeDefinition complexType(String namespaceUrl, String complexTypeName) {
        if (namespaceUrl == null || "".equals(namespaceUrl)) {
            namespaceUrl = this.targetNamespaceUrl();
        }
        return this.namespaceForUrl(namespaceUrl).complexType(complexTypeName);
    }

    public Iterator complexTypes() {
        return new CompositeIterator(this.complexTypeIterators());
    }

    private Iterator complexTypeIterators() {
        return new TransformationIterator(this.declaredNamespaces()){

            @Override
            protected Object transform(Object next) {
                return ((MWNamespace)next).complexTypes();
            }
        };
    }

    public MWSimpleTypeDefinition simpleType(String simpleTypeName) {
        return this.simpleType(this.targetNamespaceUrl, simpleTypeName);
    }

    public MWSimpleTypeDefinition simpleType(String namespaceUrl, String simpleTypeName) {
        if (namespaceUrl == null || "".equals(namespaceUrl)) {
            namespaceUrl = this.targetNamespaceUrl();
        }
        return this.namespaceForUrl(namespaceUrl).simpleType(simpleTypeName);
    }

    public Iterator simpleTypes() {
        return new CompositeIterator(this.simpleTypeIterators());
    }

    private Iterator simpleTypeIterators() {
        return new TransformationIterator(this.declaredNamespaces()){

            @Override
            protected Object transform(Object next) {
                return ((MWNamespace)next).simpleTypes();
            }
        };
    }

    public int modelGroupDefinitionCount() {
        int groupCount = 0;
        Iterator stream = this.declaredNamespaces();
        while (stream.hasNext()) {
            groupCount += ((MWNamespace)stream.next()).modelGroupDefinitionsCount();
        }
        return groupCount;
    }

    public MWModelGroupDefinition modelGroupDefinition(String modelGroupDefName) {
        return this.modelGroupDefinition(this.targetNamespaceUrl, modelGroupDefName);
    }

    public MWModelGroupDefinition modelGroupDefinition(String namespaceUrl, String modelGroupDefName) {
        if (namespaceUrl == null || "".equals(namespaceUrl)) {
            namespaceUrl = this.targetNamespaceUrl();
        }
        return this.namespaceForUrl(namespaceUrl).modelGroupDefinition(modelGroupDefName);
    }

    public MWModelGroup modelGroup(String modelGroupDefName) {
        return this.modelGroup(this.targetNamespaceUrl, modelGroupDefName);
    }

    public MWModelGroup modelGroup(String namespaceUrl, String modelGroupDefName) {
        if (namespaceUrl == null || "".equals(namespaceUrl)) {
            namespaceUrl = this.targetNamespaceUrl();
        }
        return this.modelGroupDefinition(namespaceUrl, modelGroupDefName).getModelGroup();
    }

    public Iterator structuralComponents() {
        return new CompositeIterator(this.structuralComponentIterators());
    }

    private Iterator structuralComponentIterators() {
        return new TransformationIterator(this.declaredNamespaces()){

            @Override
            protected Object transform(Object next) {
                return ((MWNamespace)next).structuralComponents();
            }
        };
    }

    public Iterator contextComponents() {
        return new CompositeIterator(this.contextComponentIterators());
    }

    private Iterator contextComponentIterators() {
        return new TransformationIterator(this.declaredNamespaces()){

            @Override
            protected Object transform(Object next) {
                return ((MWNamespace)next).contextComponents();
            }
        };
    }

    public Iterator rootElements() {
        return new CompositeIterator(this.rootElementIterators());
    }

    private Iterator rootElementIterators() {
        return new TransformationIterator(this.declaredNamespaces()){

            @Override
            protected Object transform(Object next) {
                return ((MWNamespace)next).elements();
            }
        };
    }

    public MWNamedSchemaComponent component(QName qName) {
        if (qName.getComponentType() == "attribute") {
            return this.attribute(qName.getNamespaceURI(), qName.getLocalName());
        }
        if (qName.getComponentType() == "element") {
            return this.element(qName.getNamespaceURI(), qName.getLocalName());
        }
        if (qName.getComponentType() == "complex-type") {
            return this.complexType(qName.getNamespaceURI(), qName.getLocalName());
        }
        if (qName.getComponentType() == "group") {
            return this.modelGroupDefinition(qName.getNamespaceURI(), qName.getLocalName());
        }
        return null;
    }

    public void reload() throws ResourceException {
        URI uri = this.schemaSource.validResourceURI();
        XMLSchemaLoader schemaLoader = new XMLSchemaLoader();
        XSModel xmlSchemaModel = null;
        XMLInputSource inputSource = new XMLInputSource(null, uri.toString(), null);
        SchemaDOMParser parser = new SchemaDOMParser((XMLParserConfiguration)new SchemaParsingConfig());
        try {
            xmlSchemaModel = schemaLoader.loadURI(uri.toString());
            parser.parse(inputSource);
        }
        catch (Throwable t) {
            if (t instanceof XSException) {
                throw (XSException)t;
            }
            throw new RuntimeException(t);
        }
        SchemaDOM schemaDOM = (SchemaDOM)parser.getDocument2();
        this.reload(xmlSchemaModel, schemaDOM);
        this.fireStateChanged();
        ((MWXmlProject)this.getProject()).schemaChanged(SchemaChange.schemaStructureChange(this));
        this.reloadSchemaPrefixes(schemaDOM);
    }

    private void reload(XSModel xmlSchema, SchemaDOM schemaDOM) {
        Collection oldNamespaces = CollectionTools.collection(this.declaredNamespaces());
        this.reloadTargetNamespace(xmlSchema, schemaDOM, oldNamespaces);
        StringList allNamespaceUrls = xmlSchema.getNamespaces();
        for (int i = 0; i < allNamespaceUrls.getLength(); ++i) {
            String namespaceUrl = allNamespaceUrls.item(i);
            if (namespaceUrl == null || namespaceUrl.equals(this.targetNamespaceUrl()) || namespaceUrl.equals("http://www.w3.org/2001/XMLSchema")) continue;
            this.reloadImportedNamespace(xmlSchema, schemaDOM, namespaceUrl, oldNamespaces);
        }
        Iterator stream = oldNamespaces.iterator();
        while (stream.hasNext()) {
            this.removeDeclaredNamespace((MWNamespace)stream.next());
        }
        this.resolveReferences();
    }

    private void reloadTargetNamespace(XSModel xmlSchema, SchemaDOM schemaDOM, Collection oldNamespaces) {
        String url = "";
        String uriString = schemaDOM.getDocumentElement().getAttribute("targetNamespace");
        if (uriString != null && uriString != "") {
            url = uriString;
        }
        MWNamespace targetNamespace = this.targetNamespace();
        this.setTargetNamespaceUrl(url);
        this.reloadNamespace(xmlSchema, schemaDOM, targetNamespace, url, oldNamespaces);
        targetNamespace = this.targetNamespace();
        if (targetNamespace.getNamespacePrefix().equals("")) {
            targetNamespace.setDeclared(false);
        }
    }

    private void reloadImportedNamespace(XSModel xmlSchema, SchemaDOM schemaDOM, String namespaceUrl, Collection oldNamespaces) {
        MWNamespace namespace = this.declaredNamespace(namespaceUrl);
        this.reloadNamespace(xmlSchema, schemaDOM, namespace, namespaceUrl, oldNamespaces);
    }

    private void reloadNamespace(XSModel xmlSchema, SchemaDOM schemaDOM, MWNamespace namespace, String namespaceUrl, Collection oldNamespaces) {
        if (namespace == null) {
            namespace = this.addDeclaredNamespace(namespaceUrl);
        } else {
            oldNamespaces.remove(namespace);
        }
        namespace.reload(xmlSchema, schemaDOM, namespaceUrl);
    }

    private void reloadSchemaPrefixes(SchemaDOM schemaDOM) {
        ElementImpl schemaElement = (ElementImpl)schemaDOM.getDocumentElement();
        NamedNodeMap map = schemaElement.getAttributes();
        int nAttr = map.getLength();
        for (int i = 0; i < nAttr; ++i) {
            MWNamespace namespace;
            AttrImpl attr = (AttrImpl)map.item(i);
            String localName = attr.getLocalName();
            String value = attr.getValue();
            String ns = attr.getNamespaceURI();
            if (ns != "http://www.w3.org/2000/xmlns/" || localName == "xmlns" || (namespace = this.namespaceForUrl(value)) == null) continue;
            namespace.setNamespacePrefixFromSchemaDoc(localName);
        }
    }

    public void resolveReferences() {
        Iterator stream = this.namespaces();
        while (stream.hasNext()) {
            ((MWNamespace)stream.next()).resolveReferences();
        }
    }

    @Override
    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        this.checkRequiredNamespacePrefix(currentProblems);
        this.checkDuplicateNamespacePrefix(currentProblems);
        this.checkSpacesinNamespacePrefix(currentProblems);
    }

    private void checkSpacesinNamespacePrefix(List currentProblems) {
        Iterator stream = this.namespaces();
        while (stream.hasNext()) {
            MWNamespace namespace = (MWNamespace)stream.next();
            if ("".equals(namespace.getNamespaceUrl()) || !StringTools.contains(namespace.getNamespacePrefix(), " ", '\u0000')) continue;
            currentProblems.add(this.buildProblem("0802", namespace.getNamespaceUrlForDisplay()));
        }
    }

    private void checkRequiredNamespacePrefix(List currentProblems) {
        Iterator stream = this.namespaces();
        while (stream.hasNext()) {
            MWNamespace namespace = (MWNamespace)stream.next();
            if ("".equals(namespace.getNamespaceUrl()) || !"".equals(namespace.getNamespacePrefix()) || namespace.getNamespaceUrl().equals(this.defaultNamespaceUrl)) continue;
            currentProblems.add(this.buildProblem("0800", namespace.getNamespaceUrlForDisplay()));
        }
    }

    private void checkDuplicateNamespacePrefix(List currentProblems) {
        String prefix;
        HashBag usedPrefixes = new HashBag();
        Iterator stream = this.namespaces();
        while (stream.hasNext()) {
            prefix = ((MWNamespace)stream.next()).getNamespacePrefix();
            if ("".equals(prefix)) continue;
            usedPrefixes.add(prefix);
        }
        stream = usedPrefixes.uniqueIterator();
        while (stream.hasNext()) {
            prefix = (String)stream.next();
            if (usedPrefixes.count(prefix) <= 1) continue;
            currentProblems.add(this.buildProblem("0801", prefix));
        }
    }

    public XMLSchemaReference runtimeSchemaReference() {
        if (this.schemaSource instanceof ClasspathResourceSpecification) {
            return new XMLSchemaClassPathReference(this.schemaSource.getLocation());
        }
        if (this.schemaSource instanceof FileResourceSpecification) {
            return new XMLSchemaFileReference(this.schemaSource.getLocation());
        }
        if (this.schemaSource instanceof UrlResourceSpecification) {
            return new XMLSchemaURLReference(this.schemaSource.getLocation());
        }
        return null;
    }

    public NamespaceResolver runtimeNamespaceResolver() {
        NamespaceResolver namespaceResolver = new NamespaceResolver();
        Iterator stream = this.namespaces();
        while (stream.hasNext()) {
            MWNamespace namespace = (MWNamespace)stream.next();
            if (!namespace.isDeclared() || "".equals(namespace.getNamespacePrefix())) continue;
            namespaceResolver.put(namespace.getNamespacePrefix(), namespace.getNamespaceUrl());
        }
        if (this.shouldUseDefaultNamespace() && !"".equals(this.getDefaultNamespaceUrl())) {
            namespaceResolver.setDefaultNamespaceURI(this.getDefaultNamespaceUrl());
        }
        return namespaceResolver;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWXmlSchema.class);
        descriptor.setDefaultRootElement("xml-schema");
        descriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        XMLDirectMapping targetNamespaceMapping = new XMLDirectMapping();
        targetNamespaceMapping.setAttributeName("targetNamespaceUrl");
        targetNamespaceMapping.setXPath("target-namespace-url/text()");
        targetNamespaceMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)targetNamespaceMapping);
        XMLDirectMapping defaultNamespaceMapping = new XMLDirectMapping();
        defaultNamespaceMapping.setAttributeName(DEFAULT_NAMESPACE_URL);
        defaultNamespaceMapping.setXPath("default-namespace-url/text()");
        defaultNamespaceMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)defaultNamespaceMapping);
        XMLDirectMapping shouldDefaultNamespaceMapping = new XMLDirectMapping();
        shouldDefaultNamespaceMapping.setAttributeName(SHOULD_USE_DEFAULT_NAMESPACE);
        shouldDefaultNamespaceMapping.setXPath("should-default-namespace-url/text()");
        shouldDefaultNamespaceMapping.setNullValue((Object)false);
        descriptor.addMapping((DatabaseMapping)shouldDefaultNamespaceMapping);
        XMLCompositeObjectMapping schemaLocationMapping = new XMLCompositeObjectMapping();
        schemaLocationMapping.setAttributeName(SCHEMA_SOURCE_PROPERTY);
        schemaLocationMapping.setXPath("schema-source");
        schemaLocationMapping.setReferenceClass(ResourceSpecification.class);
        descriptor.addMapping((DatabaseMapping)schemaLocationMapping);
        XMLCompositeCollectionMapping builtInNamespacesMapping = new XMLCompositeCollectionMapping();
        builtInNamespacesMapping.setAttributeName("builtInNamespaces");
        builtInNamespacesMapping.setGetMethodName("getPersistedBuiltInNamespacesForTopLink");
        builtInNamespacesMapping.setSetMethodName("setPersistedBuiltInNamespacesForTopLink");
        builtInNamespacesMapping.setXPath("built-in-namespaces/namespace");
        builtInNamespacesMapping.setReferenceClass(BuiltInNamespace.class);
        descriptor.addMapping((DatabaseMapping)builtInNamespacesMapping);
        XMLCompositeCollectionMapping namespacesMapping = new XMLCompositeCollectionMapping();
        namespacesMapping.setAttributeName("declaredNamespaces");
        namespacesMapping.setGetMethodName("getDeclaredNamespacesForToplink");
        namespacesMapping.setSetMethodName("setDeclaredNamespacesForToplink");
        namespacesMapping.setXPath("declared-namespaces/namespace");
        namespacesMapping.setReferenceClass(MWNamespace.class);
        descriptor.addMapping((DatabaseMapping)namespacesMapping);
        return descriptor;
    }

    private Collection getPersistedBuiltInNamespacesForTopLink() {
        Vector<BuiltInNamespace> persistedBuiltInNamespaces = new Vector<BuiltInNamespace>();
        ListIterator stream = this.builtInNamespaces();
        while (stream.hasNext()) {
            MWNamespace nonPersistedNamespace = (MWNamespace)stream.next();
            BuiltInNamespace persistedNamespace = new BuiltInNamespace();
            persistedNamespace.url = nonPersistedNamespace.getNamespaceUrl();
            persistedNamespace.prefix = nonPersistedNamespace.getNamespacePrefix();
            persistedNamespace.declared = nonPersistedNamespace.isDeclared();
            persistedBuiltInNamespaces.add(persistedNamespace);
        }
        return persistedBuiltInNamespaces;
    }

    private void setPersistedBuiltInNamespacesForTopLink(Collection persistedBuiltInNamespaces) {
        for (BuiltInNamespace persistedNamespace : persistedBuiltInNamespaces) {
            String url = persistedNamespace.url;
            String prefix = persistedNamespace.prefix;
            boolean declared = persistedNamespace.declared;
            MWNamespace nonpersistedNamespace = this.builtInNamespace(url);
            nonpersistedNamespace.setNamespacePrefixFromSchemaDocForTopLink(prefix);
            nonpersistedNamespace.setNamespaceIsDeclaredFromSchemaDocForTopLink(declared);
        }
    }

    private Collection getDeclaredNamespacesForToplink() {
        return CollectionTools.sortedSet(this.declaredNamespaces());
    }

    private void setDeclaredNamespacesForToplink(Collection newNamespaces) {
        this.declaredNamespaces = newNamespaces;
    }

    public String getDefaultNamespaceUrl() {
        return this.defaultNamespaceUrl;
    }

    public void setDefaultNamespaceUrl(String newDefaultNamespaceUrl) {
        String oldUrl = this.defaultNamespaceUrl;
        this.defaultNamespaceUrl = newDefaultNamespaceUrl;
        this.firePropertyChanged(DEFAULT_NAMESPACE_URL, oldUrl, newDefaultNamespaceUrl);
    }

    public boolean shouldUseDefaultNamespace() {
        return this.shouldUseDefaultNamespace;
    }

    public void setShouldUseDefaultNamespace(boolean newValue) {
        boolean oldValue = this.shouldUseDefaultNamespace;
        this.shouldUseDefaultNamespace = newValue;
        this.firePropertyChanged(SHOULD_USE_DEFAULT_NAMESPACE, oldValue, newValue);
    }

    public static class BuiltInNamespace {
        String url;
        String prefix;
        Boolean declared;

        public static XMLDescriptor buildDescriptor() {
            XMLDescriptor descriptor = new XMLDescriptor();
            descriptor.setJavaClass(BuiltInNamespace.class);
            ((AbstractDirectMapping)descriptor.addDirectMapping("url", "@url")).setNullValue((Object)"");
            ((AbstractDirectMapping)descriptor.addDirectMapping("prefix", "@prefix")).setNullValue((Object)"");
            ((AbstractDirectMapping)descriptor.addDirectMapping("declared", "@declared")).setNullValue((Object)Boolean.FALSE);
            return descriptor;
        }

        private BuiltInNamespace() {
        }
    }
}

