/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWError;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.StatusDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.DescriptorCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

abstract class AbstractMapInheritedAttributesAction
extends AbstractFrameworkAction {
    AbstractMapInheritedAttributesAction(WorkbenchContext context) {
        super(context);
    }

    @Override
    protected final void execute() {
        Collection selectedDescriptors = CollectionTools.collection((Object[])this.selectedNodes());
        Vector<StatusDialog.Status> status = new Vector<StatusDialog.Status>();
        for (ApplicationNode node : selectedDescriptors) {
            MWMappingDescriptor descriptor = (MWMappingDescriptor)node.getValue();
            try {
                this.execute(descriptor);
            }
            catch (ClassNotFoundException e) {
                MWError error = new MWError("MAP_INHERITED_ATTRIBUTES_ERROR", (Object)e.getLocalizedMessage());
                LinkedHashMap<MWError, MWError> errors = new LinkedHashMap<MWError, MWError>();
                errors.put(error, error);
                StatusDialog.Status modelStatus = StatusDialog.createStatus((Object)descriptor, errors);
                status.add(modelStatus);
            }
        }
        if (!status.isEmpty()) {
            this.showProblems(status);
        }
    }

    protected abstract void execute(MWMappingDescriptor var1) throws ClassNotFoundException;

    private void showProblems(Vector status) {
        StatusDialog dialog = new StatusDialog(this.getWorkbenchContext(), (Collection)status, "MAP_INHERITED_ATTRIBUTES_STATUS_DIALOG_TITLE", "dialog.mapInheritedAttributes"){

            @Override
            protected CellRendererAdapter buildNodeRenderer(Object value) {
                if (value instanceof MWDescriptor) {
                    return new DescriptorCellRendererAdapter(this.resourceRepository());
                }
                return super.buildNodeRenderer(value);
            }
        };
        dialog.setVisible(true);
    }
}

