/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced.multitenant;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.AdvancedMultiTenantTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.MafiaFamily;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Soldier;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.SubCapo;
import org.eclipse.persistence.testing.tests.jpa.advanced.multitenant.AdvancedMultiTenantJunitTest;

public class AdvancedMultiTenant123JunitTest
extends AdvancedMultiTenantJunitTest {
    public AdvancedMultiTenant123JunitTest() {
    }

    @Override
    public String getMULTI_TENANT_PU_123() {
        return "MulitPU-2";
    }

    public AdvancedMultiTenant123JunitTest(String name) {
        super(name);
        this.setPuName(this.getMULTI_TENANT_PU_123());
    }

    @Override
    public void setUp() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("AdvancedMultiTenant123JunitTest");
        if (!JUnitTestCase.isJPA10()) {
            suite.addTest((Test)new AdvancedMultiTenant123JunitTest("testSetup"));
            suite.addTest((Test)new AdvancedMultiTenant123JunitTest("testCreateMafiaFamily123"));
            suite.addTest((Test)new AdvancedMultiTenant123JunitTest("testValidateMafiaFamily123"));
            suite.addTest((Test)new AdvancedMultiTenant123JunitTest("testComplexMultitenantQueries"));
        }
        return suite;
    }

    @Override
    public void testSetup() {
        new AdvancedMultiTenantTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)this.getMULTI_TENANT_PU_123()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testComplexMultitenantQueries() {
        EntityManager em = AdvancedMultiTenant123JunitTest.createEntityManager((String)this.getMULTI_TENANT_PU_123());
        try {
            AdvancedMultiTenant123JunitTest.clearCache((String)this.getMULTI_TENANT_PU_123());
            em.clear();
            try {
                TypedQuery query;
                Query q;
                this.beginTransaction(em);
                try {
                    q = em.createQuery("SELECT s FROM Soldier s WHERE s.capo=?1");
                    SubCapo subCapo = new SubCapo();
                    subCapo.setId(capo123Id);
                    q.setParameter(1, (Object)subCapo);
                    List soldiers = q.getResultList();
                    AdvancedMultiTenant123JunitTest.assertTrue((String)("Incorrect number of soldiers returned [" + soldiers.size() + "], expected [1]"), (soldiers.size() == 1 ? 1 : 0) != 0);
                    AdvancedMultiTenant123JunitTest.assertTrue((String)"Mafioso returned was not a soldier", (boolean)((Soldier)soldiers.get(0)).isSoldier());
                    AdvancedMultiTenant123JunitTest.assertTrue((String)"Soldier returned was not the expected soldier", (((Soldier)soldiers.get(0)).getId() == soldier123Id ? 1 : 0) != 0);
                }
                catch (Exception e) {
                    AdvancedMultiTenant123JunitTest.fail((String)("Exception encountered on named parameter query (with tenant discriminator columns) : " + e));
                }
                try {
                    q = em.createQuery("SELECT m FROM MafiaFamily m ORDER BY m.id DESC", MafiaFamily.class);
                    q.setHint("eclipselink.join-fetch", (Object)"m.mafiosos");
                    q.getResultList();
                }
                catch (Exception e) {
                    AdvancedMultiTenant123JunitTest.fail((String)("Exception encountered on join fetch query (with tenant discriminator columns): " + e));
                }
                try {
                    q = em.createQuery("SELECT f FROM MafiaFamily f ORDER BY f.id ASC", MafiaFamily.class);
                    q.setHint("eclipselink.join-fetch", (Object)"f.mafiosos.rewards");
                    q.getResultList();
                }
                catch (Exception e) {
                    AdvancedMultiTenant123JunitTest.fail((String)("Exception encountered on nested join fetch query (with tenant discriminator columns): " + e));
                }
                try {
                    query = em.createQuery("SELECT f FROM MafiaFamily f", MafiaFamily.class);
                    query.setHint("eclipselink.batch", (Object)"f.mafiosos");
                    List families = query.getResultList();
                    AdvancedMultiTenant123JunitTest.assertTrue((String)("Incorrect number of families returned [" + families.size() + "], expected [1]"), (families.size() == 1 ? 1 : 0) != 0);
                    int size = ((MafiaFamily)families.get(0)).getMafiosos().size();
                    AdvancedMultiTenant123JunitTest.assertTrue((String)("Incorrect number of mafiosos returned [" + size + "], expected [6]"), (size == 6 ? 1 : 0) != 0);
                }
                catch (Exception e) {
                    AdvancedMultiTenant123JunitTest.fail((String)("Exception encountered on batch fetch query (with tenant discriminator columns): " + e));
                }
                try {
                    query = em.createQuery("SELECT m.address, m.family FROM Mafioso m WHERE m.address.city = 'Ottawa' AND m.family.name LIKE 'Galore'", MafiaFamily.class);
                    List results = query.getResultList();
                    int size = results.size();
                    AdvancedMultiTenant123JunitTest.assertTrue((String)("Incorrect number of results returned [" + size + "], expected [6]"), (size == 6 ? 1 : 0) != 0);
                }
                catch (Exception e) {
                    AdvancedMultiTenant123JunitTest.fail((String)("Exception encountered on mulitple select statement (with tenant discriminator columns): " + e));
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw e;
            }
            finally {
                this.closeEntityManager(em);
            }
            try {
                this.beginTransaction(em);
                int contracts = em.createNamedQuery("FindAllContracts").getResultList().size();
                int deletes = em.createNamedQuery("DeleteAllContracts").executeUpdate();
                AdvancedMultiTenant123JunitTest.assertTrue((String)("Incorrect number of contracts deleted [" + deletes + "], expected [" + contracts + "]"), (deletes == 2 ? 1 : 0) != 0);
                this.commitTransaction(em);
            }
            catch (Exception e) {
                AdvancedMultiTenant123JunitTest.fail((String)("Exception encountered on delete all query with single table (with tenant discriminator columns): " + e));
            }
            try {
                this.beginTransaction(em);
                List allFamilies = em.createNamedQuery("findAllMafiaFamilies").getResultList();
                int families = allFamilies.size();
                AdvancedMultiTenant123JunitTest.assertTrue((String)("More than one family was found [" + families + "]"), (families == 1 ? 1 : 0) != 0);
                int deletes = em.createNamedQuery("DeleteAllMafiaFamilies").executeUpdate();
                AdvancedMultiTenant123JunitTest.assertTrue((String)("Incorrect number of families deleted [" + deletes + "], expected [" + families + "]"), (deletes == 1 ? 1 : 0) != 0);
                this.commitTransaction(em);
            }
            catch (Exception e) {
                AdvancedMultiTenant123JunitTest.fail((String)("Exception encountered on delete all query with multiple table (with tenant discriminator columns): " + e));
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }
}

