/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework.server;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.UserTransaction;
import org.eclipse.persistence.testing.framework.server.ServerPlatform;

public class JEEPlatform
implements ServerPlatform {
    public static EntityManager entityManager;
    public static EntityManagerFactory entityManagerFactory;
    public static final String EJB_LOOKUP = "ejb.lookup";

    @Override
    public void initialize() {
    }

    @Override
    public boolean isTransactionActive() {
        try {
            return this.getUserTransaction().getStatus() != 6;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean getRollbackOnly() {
        try {
            return this.getUserTransaction().getStatus() != 0;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void beginTransaction() {
        try {
            this.getUserTransaction().begin();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void commitTransaction() {
        try {
            this.getUserTransaction().commit();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void rollbackTransaction() {
        try {
            this.getUserTransaction().rollback();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void closeEntityManager(EntityManager entityManager) {
    }

    public UserTransaction getUserTransaction() {
        try {
            return (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        }
        catch (NamingException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void setTransactionForRollback() {
        try {
            this.getUserTransaction().setRollbackOnly();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean isOc4j() {
        return false;
    }

    @Override
    public boolean isWeblogic() {
        return false;
    }

    @Override
    public boolean isJBoss() {
        return false;
    }

    @Override
    public boolean isSpring() {
        return false;
    }

    @Override
    public boolean isClustered() {
        return false;
    }

    @Override
    public EntityManager getEntityManager(String persistenceUnit) {
        String property = System.getProperty(EJB_LOOKUP);
        if (property == null || !property.toUpperCase().equals("TRUE")) {
            return entityManager;
        }
        String contextName = "java:comp/env/persistence/" + persistenceUnit + "/entity-manager";
        try {
            return (EntityManager)new InitialContext().lookup(contextName);
        }
        catch (NamingException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory(String persistenceUnit) {
        String property = System.getProperty(EJB_LOOKUP);
        if (property == null || !property.toUpperCase().equals("TRUE")) {
            return entityManagerFactory;
        }
        String contextName = "java:comp/env/persistence/" + persistenceUnit + "/factory";
        try {
            return (EntityManagerFactory)new InitialContext().lookup(contextName);
        }
        catch (NamingException exception) {
            throw new RuntimeException(exception);
        }
    }
}

