/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.customsqlstoredprocedures;

import java.sql.Date;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.models.insurance.objectrelational.InsuranceORSystem;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureDefinition;

public class InsuranceORStoredProcedureSystem
extends InsuranceORSystem {
    public void addDescriptors(DatabaseSession session) {
        session.logout();
        super.addDescriptors(session);
        session.login();
    }

    public StoredProcedureDefinition buildOracleStoredProcedureInsertPolicyHolders() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("SProc_Insert_PHolders");
        proc.addArgument("ssn", Long.class);
        proc.addArgument("occupation", String.class, 20);
        proc.addArgument("sex", Character.class);
        proc.addArgument("firstName", String.class, 20);
        proc.addArgument("birthDate", Date.class);
        proc.addArgument("lastName", String.class, 20);
        proc.addArgument(new FieldDefinition("address", "Address_type"));
        proc.addArgument(new FieldDefinition("childrenNames", "NameList_type"));
        proc.addArgument("phones", "PhoneList_type");
        String statement = "INSERT INTO PolicyHolders (SSN, OCCUPATION, SEX, FIRSTNAME, BIRTHDATE, LASTNAME, ADDRESS, PHONES, CHILDRENNAMES, POLICIES) VALUES (ssn, occupation, sex, firstName, birthDate, lastName, address, phones, childrenNames, null)";
        proc.addStatement(statement);
        return proc;
    }

    public StoredProcedureDefinition buildOracleStoredProcedureReadFromPolicyHolders() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("SProc_Read_PHolders");
        proc.addInOutputArgument("ssn_v", Long.class);
        proc.addOutputArgument("occupation_v", String.class, 20);
        proc.addOutputArgument("sex_v", Character.class);
        proc.addOutputArgument("firstName_v", String.class, 20);
        proc.addOutputArgument("birthDate_v", Date.class);
        proc.addOutputArgument("lastName_v", String.class, 20);
        proc.addOutputArgument("address_v", "Address_type");
        proc.addOutputArgument("childrenNames_v", "NameList_type");
        proc.addOutputArgument("phones_v", "PhoneList_type");
        String statement = "SELECT SSN, OCCUPATION, SEX, FIRSTNAME, BIRTHDATE, LASTNAME, ADDRESS, PHONES, CHILDRENNAMES into ssn_v, occupation_v, sex_v, firstName_v, birthDate_v, lastName_v, address_v, phones_v, childrenNames_v from PolicyHolders where (SSN = ssn_v)";
        proc.addStatement(statement);
        return proc;
    }

    public StoredProcedureDefinition buildOracleStoredProcedureDeletePolicyHolders() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("SProc_Delete_PHolders");
        proc.addInOutputArgument("ssn_v", Long.class);
        proc.addInOutputArgument(new FieldDefinition("occupation_v", String.class, 20));
        proc.addInOutputArgument("sex_v", Character.class);
        proc.addInOutputArgument(new FieldDefinition("firstName_v", String.class, 20));
        proc.addInOutputArgument("birthDate_v", Date.class);
        proc.addInOutputArgument(new FieldDefinition("lastName_v", String.class, 20));
        proc.addInOutputArgument(new FieldDefinition("address_v", "Address_type"));
        proc.addInOutputArgument(new FieldDefinition("childrenNames_v", "NameList_type"));
        proc.addInOutputArgument(new FieldDefinition("phones_v", "PhoneList_type"));
        String statement = "SELECT SSN, OCCUPATION, SEX, FIRSTNAME, BIRTHDATE, LASTNAME, ADDRESS, PHONES, CHILDRENNAMES into ssn_v, occupation_v, sex_v, firstName_v, birthDate_v, lastName_v, address_v, phones_v, childrenNames_v from PolicyHolders where (SSN = ssn_v)";
        proc.addStatement(statement);
        proc.addStatement("DELETE FROM PolicyHolders where (SSN = ssn)");
        return proc;
    }

    @Override
    public void createTables(DatabaseSession session) {
        super.createTables(session);
        DatabasePlatform platform = session.getLogin().getPlatform();
        SchemaManager schema = new SchemaManager(session);
        if (platform.isSQLServer()) {
            // empty if block
        }
        if (platform.isSybase() || platform.isSQLAnywhere()) {
            // empty if block
        }
        if (platform.isOracle()) {
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleStoredProcedureInsertPolicyHolders());
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleStoredProcedureReadFromPolicyHolders());
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleStoredProcedureDeletePolicyHolders());
        }
        if (platform.isDB2()) {
            // empty if block
        }
    }
}

