/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.visit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.BaseDatabaseTypeVisitor;

public class TableTypeVisitor
extends BaseDatabaseTypeVisitor {
    public String tableName;
    public String schema;
    public List<String> columnData = new ArrayList<String>();
    public List<String> pkColumns = new ArrayList<String>();

    @Override
    public void beginVisit(TableType databaseType) {
        this.tableName = databaseType.getTableName();
        this.schema = databaseType.getSchema();
    }

    @Override
    public void beginVisit(FieldType databaseType) {
        if (databaseType.notNull()) {
            this.columnData.add(String.valueOf(databaseType.getFieldName()) + "\t" + databaseType.getTypeName() + " (NOT NULL)");
        } else {
            this.columnData.add(String.valueOf(databaseType.getFieldName()) + "\t" + databaseType.getTypeName());
        }
        if (databaseType.pk()) {
            this.pkColumns.add(databaseType.getFieldName());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TABLE ");
        if (this.schema != null) {
            sb.append(this.schema);
            sb.append(".");
        }
        sb.append(this.tableName);
        sb.append(" (\n");
        for (String col : this.columnData) {
            sb.append("\t");
            sb.append(col);
            sb.append("\n");
        }
        if (this.pkColumns.size() > 0) {
            sb.append("\t");
            sb.append("PRIMARY KEY (");
            int i = 0;
            while (i < this.pkColumns.size()) {
                sb.append(this.pkColumns.get(i));
                if (++i >= this.pkColumns.size()) continue;
                sb.append(',');
            }
            sb.append(")\n");
        }
        sb.append(")");
        return sb.toString();
    }
}

