/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import java.util.Vector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.clientserver.ClientServerConcurrentWriteTest;
import org.eclipse.persistence.testing.tests.clientserver.EmployeeClient;
import org.eclipse.persistence.testing.tests.clientserver.EmployeeSeqDeadlockClient;
import org.eclipse.persistence.testing.tests.clientserver.FIFO;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class ClientServerSequenceDeadlockTest
extends ClientServerConcurrentWriteTest {
    protected FIFO[] fifoArray;
    protected int[] clientStateArray;
    protected long[] clientLastActionTimeArray;
    protected int numObjects = 25;
    protected int doneClients;
    protected boolean deadlock;
    protected static final int THREAD_UNDEFINED = 0;
    protected static final int THREAD_RUNNING = 0;
    protected static final int THREAD_LOCKED = 1;
    protected static final int THREAD_EXITED = 2;
    protected static final long TIME_TO_PRESUME_DEADLOCK = 300000L;

    public ClientServerSequenceDeadlockTest() {
        this.setDescription("Tests concurrent writing of objects of two types for sequencing deadlock");
        this.fifoArray = new FIFO[NUM_CLIENTS];
        this.clientStateArray = new int[NUM_CLIENTS];
        this.clientLastActionTimeArray = new long[NUM_CLIENTS];
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.getClients().size(); ++i) {
            EmployeeSeqDeadlockClient client = (EmployeeSeqDeadlockClient)this.getClients().elementAt(i);
            if (this.clientStateArray[i] != 0) continue;
            client.stop();
        }
        this.server.logout();
        this.setClients(new Vector());
    }

    @Override
    public void setup() {
        this.login = (DatabaseLogin)this.getSession().getLogin().clone();
        if (this.login.getPlatform().isDB2()) {
            this.login.setTransactionIsolation(8);
        }
        this.server = new Server(this.login);
        this.server.serverSession.getLogin().getDefaultSequence().setPreallocationSize(1);
        this.server.serverSession.setSessionLog(this.getSession().getSessionLog());
        this.server.login();
        this.server.copyDescriptors(this.getSession());
        for (int i = 0; i < NUM_CLIENTS; ++i) {
            boolean createEmployees = i % 2 == 0;
            this.fifoArray[i] = new FIFO(this.numObjects);
            this.getClients().addElement(new EmployeeSeqDeadlockClient(this.server, this.getSession(), "Client " + i, this.numObjects, createEmployees, this.fifoArray[i]));
            this.clientStateArray[i] = 0;
            this.clientLastActionTimeArray[i] = 0L;
        }
        this.doneClients = 0;
        this.deadlock = false;
    }

    @Override
    public void test() {
        int i;
        for (i = 0; i < NUM_CLIENTS; ++i) {
            EmployeeSeqDeadlockClient client = (EmployeeSeqDeadlockClient)this.clients.elementAt(i);
            client.start();
            this.clientStateArray[i] = 0;
        }
        while (this.doneClients < NUM_CLIENTS) {
            for (i = 0; i < NUM_CLIENTS; ++i) {
                if (this.clientStateArray[i] != 0) continue;
                if (NUM_CLIENTS - this.doneClients == 1) {
                    ((EmployeeClient)this.getClients().elementAt(i)).pleaseStop();
                }
                long currentTime = System.currentTimeMillis();
                if (!this.fifoArray[i].isEmpty()) {
                    this.clientLastActionTimeArray[i] = currentTime;
                    int objectNumber = (Integer)this.fifoArray[i].removeHead();
                    if (objectNumber != this.numObjects && objectNumber != -1) continue;
                    this.clientStateArray[i] = 2;
                    ++this.doneClients;
                    continue;
                }
                if (this.clientLastActionTimeArray[i] == 0L) {
                    this.clientLastActionTimeArray[i] = System.currentTimeMillis();
                    continue;
                }
                if (currentTime - this.clientLastActionTimeArray[i] < 300000L) continue;
                this.clientStateArray[i] = 1;
                this.deadlock = true;
                ++this.doneClients;
                ((Thread)this.getClients().elementAt(i)).stop();
            }
        }
    }

    @Override
    public void verify() {
        for (int i = 0; i < NUM_CLIENTS; ++i) {
            EmployeeSeqDeadlockClient client = (EmployeeSeqDeadlockClient)this.clients.elementAt(i);
            if (!client.anErrorOccurred()) continue;
            throw new TestErrorException("An exception " + client.getTestException() + " occurred in client " + client.toString());
        }
        if (this.deadlock) {
            throw new TestErrorException("Looks like it's a deadlock");
        }
    }
}

