/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinTable;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.dom.InverseJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.Table;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class JoinTable
extends Table
implements ExternalJoinTable {
    static final String JOIN_TABLE = "join-table";

    JoinTable(AbstractExternalForm parent) {
        super(parent);
    }

    @Override
    public void addInverseJoinColumn(int index, String name) {
        InverseJoinColumn joinColumn = this.buildInverseJoinColumn(index);
        joinColumn.addSelf();
        joinColumn.setName(name);
    }

    @Override
    public void addJoinColumn(int index, String name) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.addSelf();
        joinColumn.setName(name);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("join-column");
        names.add("inverse-join-column");
        names.add("unique-constraint");
        return names;
    }

    private InverseJoinColumn buildInverseJoinColumn(int index) {
        return new InverseJoinColumn(this, index);
    }

    private JoinColumn buildJoinColumn(int index) {
        return new JoinColumn(this, index);
    }

    @Override
    protected String getElementName() {
        return JOIN_TABLE;
    }

    @Override
    public ExternalJoinColumn getInverseJoinColumn(int index) {
        Element element = this.getChild("inverse-join-column", index);
        if (element == null) {
            return null;
        }
        return this.buildInverseJoinColumn(index);
    }

    @Override
    public ExternalJoinColumn getJoinColumn(int index) {
        Element element = this.getChild("join-column", index);
        if (element == null) {
            return null;
        }
        return this.buildJoinColumn(index);
    }

    @Override
    public ListIterable<ExternalJoinColumn> inverseJoinColumns() {
        int count = this.inverseJoinColumnsSize();
        ArrayList<InverseJoinColumn> joinColumns = new ArrayList<InverseJoinColumn>(count);
        int index = count;
        while (--index >= 0) {
            InverseJoinColumn joinColumn = this.buildInverseJoinColumn(index);
            joinColumns.add(0, joinColumn);
        }
        return new ListListIterable(joinColumns);
    }

    @Override
    public int inverseJoinColumnsSize() {
        return this.getChildrenSize("inverse-join-column");
    }

    @Override
    public boolean isDefault() {
        return !this.hasChildren() && !this.hasAttributes();
    }

    @Override
    public ListIterable<ExternalJoinColumn> joinColumns() {
        int count = this.joinColumnsSize();
        ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>(count);
        int index = count;
        while (--index >= 0) {
            JoinColumn joinColumn = this.buildJoinColumn(index);
            joinColumns.add(0, joinColumn);
        }
        return new ListListIterable(joinColumns);
    }

    @Override
    public int joinColumnsSize() {
        return this.getChildrenSize("join-column");
    }

    @Override
    public void removeInverseJoinColumn(int index) {
        InverseJoinColumn joinColumn = this.buildInverseJoinColumn(index);
        joinColumn.removeSelf();
    }

    @Override
    public void removeJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.removeSelf();
    }
}

