/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.mapping.orm.ExternalTableGenerator;
import org.eclipse.persistence.tools.mapping.orm.ExternalUniqueConstraint;
import org.eclipse.persistence.tools.mapping.orm.dom.BasicMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.IdMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.MappedSuperClassEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.dom.PrimaryKeyGenerator;
import org.eclipse.persistence.tools.mapping.orm.dom.UniqueConstraint;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class TableGenerator
extends PrimaryKeyGenerator
implements ExternalTableGenerator {
    static final String PK_COLUMN_NAME = "pk-column-name";
    static final String PK_COLUMN_VALUE = "pk-column-value";
    static final String TABLE = "table";
    static final String TABLE_GENERATOR = "table-generator";
    static final String VALUE_COLUMN_NAME = "value-column-name";

    TableGenerator(BasicMapping parent) {
        super(parent);
    }

    TableGenerator(MappedSuperClassEntity parent) {
        super(parent);
    }

    TableGenerator(IdMapping parent) {
        super(parent);
    }

    TableGenerator(ORMConfiguration parent, int index) {
        super(parent, index);
    }

    @Override
    public void addUniqueConstraint(int index, ListIterator<String> columnNames) {
        UniqueConstraint uniqueConstraint = this.buildUniqueConstraint(index);
        uniqueConstraint.addSelf();
        uniqueConstraint.setColumnNames(columnNames);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add(TABLE);
        names.add("catalog");
        names.add("schema");
        names.add(PK_COLUMN_NAME);
        names.add(VALUE_COLUMN_NAME);
        names.add(PK_COLUMN_VALUE);
        names.add("initial-value");
        names.add("allocation-size");
        return names;
    }

    private UniqueConstraint buildUniqueConstraint(int index) {
        return new UniqueConstraint(this, index);
    }

    @Override
    protected String getElementName() {
        return TABLE_GENERATOR;
    }

    @Override
    public String getPKColumnName() {
        return this.getAttribute(PK_COLUMN_NAME);
    }

    @Override
    public String getPKColumnValue() {
        return this.getAttribute(PK_COLUMN_VALUE);
    }

    @Override
    public String getTableName() {
        return this.getAttribute(TABLE);
    }

    @Override
    public ExternalUniqueConstraint getUniqueConstraint(int index) {
        Element element = this.getChild("unique-constraint", index);
        if (element == null) {
            return null;
        }
        return this.buildUniqueConstraint(index);
    }

    @Override
    public String getValueColumnName() {
        return this.getAttribute(VALUE_COLUMN_NAME);
    }

    @Override
    public void removeUniqueConstraint(int index) {
        UniqueConstraint uniqueConstraint = this.buildUniqueConstraint(index);
        uniqueConstraint.removeSelf();
        if (this.shouldBeRemoved()) {
            this.removeSelf();
        }
    }

    @Override
    public void setPKColumnName(String name) {
        this.setAttribute(PK_COLUMN_NAME, name);
        if (this.shouldBeRemoved()) {
            this.removeSelf();
        }
    }

    @Override
    public void setPKColumnValue(String value) {
        this.setAttribute(PK_COLUMN_VALUE, value);
        if (this.shouldBeRemoved()) {
            this.removeSelf();
        }
    }

    @Override
    public void setTableName(String name) {
        this.setAttribute(TABLE, name);
        if (this.shouldBeRemoved()) {
            this.removeSelf();
        }
    }

    @Override
    public void setValueColumnName(String name) {
        this.setAttribute(VALUE_COLUMN_NAME, name);
        if (this.shouldBeRemoved()) {
            this.removeSelf();
        }
    }

    @Override
    public ListIterable<ExternalUniqueConstraint> uniqueConstraints() {
        int count = this.uniqueConstraintsSize();
        ArrayList<UniqueConstraint> uniqueConstraints = new ArrayList<UniqueConstraint>(count);
        int index = count;
        while (--index >= 0) {
            UniqueConstraint uniqueConstraint = this.buildUniqueConstraint(index);
            uniqueConstraints.add(0, uniqueConstraint);
        }
        return new ListListIterable(uniqueConstraints);
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.getChildrenSize("unique-constraint");
    }
}

