/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model.value.swing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.ListModel;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.HashBag;
import org.eclipse.persistence.tools.utility.model.listener.ListChangeListener;
import org.eclipse.persistence.tools.utility.model.value.CollectionValueModel;
import org.eclipse.persistence.tools.utility.model.value.ListValueModel;
import org.eclipse.persistence.tools.utility.model.value.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.utility.model.value.SimpleListValueModel;
import org.eclipse.persistence.tools.utility.model.value.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.utility.model.value.SortedListValueModelWrapper;
import org.eclipse.persistence.tools.utility.model.value.swing.ListModelAdapter;
import org.eclipse.persistence.tools.utility.tests.model.value.CoordinatedList;

public class ListModelAdapterTests
extends TestCase {
    public ListModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private ListModelAdapter buildListModel(ListValueModel<String> listHolder) {
        return new ListModelAdapter(listHolder){

            protected ListChangeListener buildListChangeListener() {
                return this.buildListChangeListener_();
            }
        };
    }

    private ListModel buildListModel(CollectionValueModel<String> collectionHolder) {
        return new ListModelAdapter(collectionHolder){

            protected ListChangeListener buildListChangeListener() {
                return this.buildListChangeListener_();
            }
        };
    }

    public void testCollectionSynchronization() {
        SimpleCollectionValueModel<String> collectionHolder = this.buildCollectionHolder();
        ListModel listModel = this.buildListModel((CollectionValueModel<String>)collectionHolder);
        CoordinatedList<String> synchList = new CoordinatedList<String>(listModel);
        ListModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare(listModel, synchList);
        collectionHolder.add((Object)"tom");
        collectionHolder.add((Object)"dick");
        collectionHolder.add((Object)"harry");
        collectionHolder.add(null);
        ListModelAdapterTests.assertEquals((int)10, (int)synchList.size());
        this.compare(listModel, synchList);
        collectionHolder.remove((Object)"foo");
        collectionHolder.remove((Object)"jar");
        collectionHolder.remove((Object)"harry");
        collectionHolder.remove(null);
        ListModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare(listModel, synchList);
    }

    public void testListSynchronization() {
        SimpleListValueModel<String> listHolder = this.buildListHolder();
        ListModelAdapter listModel = this.buildListModel((ListValueModel<String>)listHolder);
        CoordinatedList<String> synchList = new CoordinatedList<String>((ListModel)listModel);
        ListModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListModel)listModel, synchList);
        listHolder.add(6, (Object)"tom");
        listHolder.add(7, (Object)"dick");
        listHolder.add(8, (Object)"harry");
        listHolder.add(9, null);
        ListModelAdapterTests.assertEquals((int)10, (int)synchList.size());
        this.compare((ListModel)listModel, synchList);
        listHolder.remove(9);
        listHolder.remove(8);
        listHolder.remove(4);
        listHolder.remove(0);
        ListModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListModel)listModel, synchList);
    }

    public void testSetModel() {
        SimpleListValueModel<String> listHolder1 = this.buildListHolder();
        ListModelAdapter listModel = this.buildListModel((ListValueModel<String>)listHolder1);
        CoordinatedList<String> synchList = new CoordinatedList<String>((ListModel)listModel);
        ListModelAdapterTests.assertTrue((boolean)listHolder1.hasAnyListChangeListeners("list values"));
        ListModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListModel)listModel, synchList);
        SimpleListValueModel<String> listHolder2 = this.buildListHolder2();
        listModel.setModel(listHolder2);
        ListModelAdapterTests.assertEquals((int)3, (int)synchList.size());
        this.compare((ListModel)listModel, synchList);
        ListModelAdapterTests.assertTrue((boolean)listHolder1.hasNoListChangeListeners("list values"));
        ListModelAdapterTests.assertTrue((boolean)listHolder2.hasAnyListChangeListeners("list values"));
        listModel.setModel((ListValueModel)new SimpleListValueModel());
        ListModelAdapterTests.assertEquals((int)0, (int)synchList.size());
        this.compare((ListModel)listModel, synchList);
        ListModelAdapterTests.assertTrue((boolean)listHolder1.hasNoListChangeListeners("list values"));
        ListModelAdapterTests.assertTrue((boolean)listHolder2.hasNoListChangeListeners("list values"));
    }

    private void compare(ListModel listModel, List<String> list) {
        ListModelAdapterTests.assertEquals((int)listModel.getSize(), (int)list.size());
        int i = 0;
        while (i < listModel.getSize()) {
            ListModelAdapterTests.assertEquals(listModel.getElementAt(i), (Object)list.get(i));
            ++i;
        }
    }

    public void testCollectionSort() {
        this.verifyCollectionSort(null);
    }

    public void testListSort() {
        this.verifyListSort(null);
    }

    public void testCustomCollectionSort() {
        this.verifyCollectionSort(this.buildCustomComparator());
    }

    public void testCustomListSort() {
        this.verifyListSort(this.buildCustomComparator());
    }

    private Comparator<String> buildCustomComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s2.compareTo(s1);
            }
        };
    }

    private void verifyCollectionSort(Comparator<String> comparator) {
        SimpleCollectionValueModel<String> collectionHolder = this.buildCollectionHolder();
        ListModelAdapter listModel = this.buildListModel((ListValueModel<String>)new SortedListValueModelAdapter(collectionHolder, comparator));
        CoordinatedList<String> synchList = new CoordinatedList<String>((ListModel)listModel);
        ListModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compareSort((ListModel)listModel, synchList, comparator);
        collectionHolder.add((Object)"tom");
        collectionHolder.add((Object)"dick");
        collectionHolder.add((Object)"harry");
        ListModelAdapterTests.assertEquals((int)9, (int)synchList.size());
        this.compareSort((ListModel)listModel, synchList, comparator);
        collectionHolder.remove((Object)"foo");
        collectionHolder.remove((Object)"jar");
        collectionHolder.remove((Object)"harry");
        ListModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compareSort((ListModel)listModel, synchList, comparator);
    }

    private void verifyListSort(Comparator<String> comparator) {
        SimpleListValueModel<String> listHolder = this.buildListHolder();
        ListModelAdapter listModel = this.buildListModel((ListValueModel<String>)new SortedListValueModelWrapper(listHolder, comparator));
        CoordinatedList<String> synchList = new CoordinatedList<String>((ListModel)listModel);
        ListModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compareSort((ListModel)listModel, synchList, comparator);
        listHolder.add(0, (Object)"tom");
        listHolder.add(0, (Object)"dick");
        listHolder.add(0, (Object)"harry");
        ListModelAdapterTests.assertEquals((int)9, (int)synchList.size());
        this.compareSort((ListModel)listModel, synchList, comparator);
        listHolder.remove(8);
        listHolder.remove(4);
        listHolder.remove(0);
        listHolder.remove(5);
        ListModelAdapterTests.assertEquals((int)5, (int)synchList.size());
        this.compareSort((ListModel)listModel, synchList, comparator);
    }

    private void compareSort(ListModel listModel, List<String> list, Comparator<String> comparator) {
        TreeSet<String> ss = new TreeSet<String>(comparator);
        int i = 0;
        while (i < listModel.getSize()) {
            ss.add((String)listModel.getElementAt(i));
            ++i;
        }
        ListModelAdapterTests.assertEquals((int)ss.size(), (int)list.size());
        Iterator stream1 = ss.iterator();
        Iterator<String> stream2 = list.iterator();
        while (stream1.hasNext()) {
            ListModelAdapterTests.assertEquals((String)((String)stream1.next()), (String)stream2.next());
        }
    }

    public void testHasListeners() throws Exception {
        SimpleListValueModel<String> listHolder = this.buildListHolder();
        ListModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ListModelAdapter listModel = this.buildListModel((ListValueModel<String>)listHolder);
        ListModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        this.verifyHasNoListeners((ListModel)listModel);
        CoordinatedList synchList = new CoordinatedList((ListModel)listModel);
        ListModelAdapterTests.assertTrue((boolean)listHolder.hasAnyListChangeListeners("list values"));
        this.verifyHasListeners((ListModel)listModel);
        listModel.removeListDataListener(synchList);
        ListModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        this.verifyHasNoListeners((ListModel)listModel);
    }

    public void testGetSize() throws Exception {
        SimpleListValueModel<String> listHolder = this.buildListHolder();
        ListModelAdapter listModel = this.buildListModel((ListValueModel<String>)listHolder);
        this.verifyHasNoListeners((ListModel)listModel);
        ListModelAdapterTests.assertEquals((int)6, (int)listModel.getSize());
        CoordinatedList synchList = new CoordinatedList((ListModel)listModel);
        this.verifyHasListeners((ListModel)listModel);
        ListModelAdapterTests.assertEquals((int)6, (int)listModel.getSize());
        listModel.removeListDataListener(synchList);
        this.verifyHasNoListeners((ListModel)listModel);
        ListModelAdapterTests.assertEquals((int)6, (int)listModel.getSize());
    }

    public void testGetElementAt() throws Exception {
        SimpleListValueModel<String> listHolder = this.buildListHolder();
        ListModelAdapter listModel = this.buildListModel((ListValueModel<String>)new SortedListValueModelWrapper(listHolder));
        CoordinatedList synchList = new CoordinatedList((ListModel)listModel);
        this.verifyHasListeners((ListModel)listModel);
        ListModelAdapterTests.assertEquals((Object)"bar", listModel.getElementAt(0));
        ListModelAdapterTests.assertEquals((String)"bar", (String)((String)synchList.get(0)));
    }

    private void verifyHasNoListeners(ListModel listModel) throws Exception {
        boolean hasNoListeners = (Boolean)ObjectTools.execute((Object)listModel, (String)"hasNoListDataListeners");
        ListModelAdapterTests.assertTrue((boolean)hasNoListeners);
    }

    private void verifyHasListeners(ListModel listModel) throws Exception {
        boolean hasListeners = (Boolean)ObjectTools.execute((Object)listModel, (String)"hasListDataListeners");
        ListModelAdapterTests.assertTrue((boolean)hasListeners);
    }

    private SimpleCollectionValueModel<String> buildCollectionHolder() {
        return new SimpleCollectionValueModel(this.buildCollection());
    }

    private Collection<String> buildCollection() {
        HashBag bag = new HashBag();
        this.populateCollection((Collection<String>)bag);
        return bag;
    }

    private SimpleListValueModel<String> buildListHolder() {
        return new SimpleListValueModel(this.buildList());
    }

    private List<String> buildList() {
        ArrayList<String> list = new ArrayList<String>();
        this.populateCollection(list);
        return list;
    }

    private void populateCollection(Collection<String> c) {
        c.add("foo");
        c.add("bar");
        c.add("baz");
        c.add("joo");
        c.add("jar");
        c.add("jaz");
    }

    private SimpleListValueModel<String> buildListHolder2() {
        return new SimpleListValueModel(this.buildList2());
    }

    private List<String> buildList2() {
        ArrayList<String> list = new ArrayList<String>();
        this.populateCollection2(list);
        return list;
    }

    private void populateCollection2(Collection<String> c) {
        c.add("tom");
        c.add("dick");
        c.add("harry");
    }
}

