/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterator;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.collection.HashBag;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.collection.Queue;
import org.eclipse.persistence.tools.utility.collection.Stack;
import org.eclipse.persistence.tools.utility.command.InterruptibleParameterizedCommand;
import org.eclipse.persistence.tools.utility.command.ParameterizedCommand;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.iterable.IterableTools;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterator.ArrayIterator;
import org.eclipse.persistence.tools.utility.iterator.ArrayListIterator;
import org.eclipse.persistence.tools.utility.iterator.ChainIterator;
import org.eclipse.persistence.tools.utility.iterator.CloneIterator;
import org.eclipse.persistence.tools.utility.iterator.CloneListIterator;
import org.eclipse.persistence.tools.utility.iterator.CompositeIterator;
import org.eclipse.persistence.tools.utility.iterator.CompositeListIterator;
import org.eclipse.persistence.tools.utility.iterator.EmptyIterator;
import org.eclipse.persistence.tools.utility.iterator.EmptyListIterator;
import org.eclipse.persistence.tools.utility.iterator.EnumerationIterator;
import org.eclipse.persistence.tools.utility.iterator.FilteringIterator;
import org.eclipse.persistence.tools.utility.iterator.GraphIterator;
import org.eclipse.persistence.tools.utility.iterator.LateralIteratorWrapper;
import org.eclipse.persistence.tools.utility.iterator.LateralListIteratorWrapper;
import org.eclipse.persistence.tools.utility.iterator.NullElementIterator;
import org.eclipse.persistence.tools.utility.iterator.NullElementListIterator;
import org.eclipse.persistence.tools.utility.iterator.PeekableIterator;
import org.eclipse.persistence.tools.utility.iterator.QueueIterator;
import org.eclipse.persistence.tools.utility.iterator.ReadOnlyCompositeListIterator;
import org.eclipse.persistence.tools.utility.iterator.ReadOnlyIterator;
import org.eclipse.persistence.tools.utility.iterator.ReadOnlyListIterator;
import org.eclipse.persistence.tools.utility.iterator.RepeatingElementIterator;
import org.eclipse.persistence.tools.utility.iterator.RepeatingElementListIterator;
import org.eclipse.persistence.tools.utility.iterator.ResultSetIterator;
import org.eclipse.persistence.tools.utility.iterator.ReverseIterator;
import org.eclipse.persistence.tools.utility.iterator.SimultaneousIterator;
import org.eclipse.persistence.tools.utility.iterator.SimultaneousListIterator;
import org.eclipse.persistence.tools.utility.iterator.SingleElementIterator;
import org.eclipse.persistence.tools.utility.iterator.SingleElementListIterator;
import org.eclipse.persistence.tools.utility.iterator.StackIterator;
import org.eclipse.persistence.tools.utility.iterator.SubIteratorWrapper;
import org.eclipse.persistence.tools.utility.iterator.SubListIteratorWrapper;
import org.eclipse.persistence.tools.utility.iterator.SuperIteratorWrapper;
import org.eclipse.persistence.tools.utility.iterator.SuperListIteratorWrapper;
import org.eclipse.persistence.tools.utility.iterator.SynchronizedIterator;
import org.eclipse.persistence.tools.utility.iterator.SynchronizedListIterator;
import org.eclipse.persistence.tools.utility.iterator.TransformationIterator;
import org.eclipse.persistence.tools.utility.iterator.TransformationListIterator;
import org.eclipse.persistence.tools.utility.iterator.TreeIterator;
import org.eclipse.persistence.tools.utility.transformer.Transformer;

public final class IteratorTools {
    public static final Transformer ITERABLE_ITERATOR_TRANSFORMER = new IterableIteratorTransformer();
    public static final Transformer LIST_ITERABLE_LIST_ITERATOR_TRANSFORMER = new ListIterableListIteratorTransformer();
    public static final Transformer LIST_LIST_ITERATOR_TRANSFORMER = new ListListIteratorTransformer();
    public static final Transformer READ_ONLY_LIST_ITERABLE_LIST_ITERATOR_TRANSFORMER = new ReadOnlyListIterableListIteratorTransformer();
    public static final Transformer READ_ONLY_LIST_LIST_ITERATOR_TRANSFORMER = new ReadOnlyListListIteratorTransformer();

    public static <E> HashBag<E> bag(Iterator<? extends E> iterator) {
        return CollectionTools.bag(iterator);
    }

    public static <E> HashBag<E> bag(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.bag(iterator, iteratorSize);
    }

    public static <E> HashBag<E> collection(Iterator<? extends E> iterator) {
        return CollectionTools.collection(iterator);
    }

    public static <E> HashBag<E> collection(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.collection(iterator, iteratorSize);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(Iterator<?> iterator, Object value) {
        block2: {
            if (value != null) ** GOTO lbl8
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(iterator.next())) continue;
                return true;
lbl8:
                // 2 sources

                ** while (iterator.hasNext())
            }
        }
        return false;
    }

    public static boolean containsAll(Iterator<?> iterator, Collection<?> collection) {
        return CollectionTools.set(iterator).containsAll(collection);
    }

    public static boolean containsAll(Iterator<?> iterator, int iteratorSize, Collection<?> collection) {
        return CollectionTools.set(iterator, iteratorSize).containsAll(collection);
    }

    public static boolean containsAll(Iterator<?> iterator, Iterable<?> iterable) {
        return CollectionTools.containsAll(CollectionTools.set(iterator), iterable);
    }

    public static boolean containsAll(Iterator<?> iterator, int iteratorSize, Iterable<?> iterable) {
        return CollectionTools.containsAll(CollectionTools.set(iterator, iteratorSize), iterable);
    }

    public static boolean containsAll(Iterator<?> iterator1, Iterator<?> iterator2) {
        return CollectionTools.containsAll(CollectionTools.set(iterator1), iterator2);
    }

    public static boolean containsAll(Iterator<?> iterator1, int iterator1Size, Iterator<?> iterator2) {
        return CollectionTools.containsAll(CollectionTools.set(iterator1, iterator1Size), iterator2);
    }

    public static boolean containsAll(Iterator<?> iterator, Object ... array) {
        return CollectionTools.containsAll(CollectionTools.set(iterator), array);
    }

    public static boolean containsAll(Iterator<?> iterator, int iteratorSize, Object ... array) {
        return CollectionTools.containsAll(CollectionTools.set(iterator, iteratorSize), array);
    }

    public static boolean elementsAreDifferent(Iterator<?> iterator1, Iterator<?> iterator2) {
        return !IteratorTools.elementsAreEqual(iterator1, iterator2);
    }

    public static boolean elementsAreEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (!ObjectTools.notEquals(iterator1.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static boolean elementsAreIdentical(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (iterator1.next() == iterator2.next()) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static boolean elementsAreNotIdentical(Iterator<?> iterator1, Iterator<?> iterator2) {
        return !IteratorTools.elementsAreIdentical(iterator1, iterator2);
    }

    public static <E> void execute(Iterator<? extends E> iterator, ParameterizedCommand<E> command) {
        while (iterator.hasNext()) {
            command.execute(iterator.next());
        }
    }

    public static <E> void execute(Iterator<? extends E> iterator, InterruptibleParameterizedCommand<E> command) throws InterruptedException {
        while (iterator.hasNext()) {
            command.execute(iterator.next());
        }
    }

    public static <E> E get(Iterator<? extends E> iterator, int index) {
        int i = 0;
        while (iterator.hasNext()) {
            E next = iterator.next();
            if (i++ != index) continue;
            return next;
        }
        throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(index)) + ':' + String.valueOf(i));
    }

    public static int hashCode(Iterator<?> iterator) {
        int hash = 1;
        while (iterator.hasNext()) {
            Object next = iterator.next();
            hash = 31 * hash + (next == null ? 0 : next.hashCode());
        }
        return hash;
    }

    public static int indexOf(Iterator<?> iterator, Object value) {
        if (value == null) {
            int i = 0;
            while (iterator.hasNext()) {
                if (iterator.next() == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (iterator.hasNext()) {
                if (value.equals(iterator.next())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(Iterator<?> iterator, Object value) {
        int last = -1;
        if (value == null) {
            int i = 0;
            while (iterator.hasNext()) {
                if (iterator.next() == null) {
                    last = i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (iterator.hasNext()) {
                if (value.equals(iterator.next())) {
                    last = i;
                }
                ++i;
            }
        }
        return last;
    }

    public static <E> E last(Iterator<E> iterator) {
        E last;
        do {
            last = iterator.next();
        } while (iterator.hasNext());
        return last;
    }

    public static <E> ArrayList<E> list(Iterator<? extends E> iterator) {
        return ListTools.list(iterator);
    }

    public static <E> ArrayList<E> list(Iterator<? extends E> iterator, int iteratorSize) {
        return ListTools.list(iterator, iteratorSize);
    }

    public static int size(Iterator<?> iterator) {
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return !iterator.hasNext();
    }

    public static <E extends Comparable<? super E>> ListIterator<E> sort(Iterator<? extends E> iterator) {
        return IteratorTools.sort(iterator, null);
    }

    public static <E extends Comparable<? super E>> ListIterator<E> sort(Iterator<? extends E> iterator, int iteratorSize) {
        return IteratorTools.sort(iterator, null, iteratorSize);
    }

    public static <E> ListIterator<E> sort(Iterator<? extends E> iterator, Comparator<? super E> comparator) {
        return ListTools.sort(ListTools.list(iterator), comparator).listIterator();
    }

    public static <E> ListIterator<E> sort(Iterator<? extends E> iterator, Comparator<? super E> comparator, int iteratorSize) {
        return ListTools.sort(ListTools.list(iterator, iteratorSize), comparator).listIterator();
    }

    public static Object[] toArray(Iterator<?> iterator) {
        return IteratorTools.list(iterator).toArray();
    }

    public static Object[] toArray(Iterator<?> iterator, int iteratorSize) {
        return IteratorTools.list(iterator, iteratorSize).toArray();
    }

    public static <E> E[] toArray(Iterator<? extends E> iterator, E[] array) {
        return IteratorTools.list(iterator).toArray(array);
    }

    public static <E> E[] toArray(Iterator<? extends E> iterator, int iteratorSize, E[] array) {
        return IteratorTools.list(iterator, iteratorSize).toArray(array);
    }

    public static <E> ChainIterator<E> chainIterator(E startLink, ChainIterator.Linker<E> linker) {
        return new ChainIterator<E>(startLink, linker);
    }

    public static <E> CloneIterator<E> cloneIterator(Collection<? extends E> collection) {
        return new CloneIterator<E>(collection);
    }

    public static <E> CloneIterator<E> cloneIterator(Collection<? extends E> collection, CloneIterator.Remover<E> remover) {
        return new CloneIterator<E>(collection, remover);
    }

    public static <E> CloneIterator<E> cloneIterator(E[] array) {
        return new CloneIterator<E>(array);
    }

    public static <E> CloneIterator<E> cloneIterator(E[] array, CloneIterator.Remover<E> remover) {
        return new CloneIterator<E>(array, remover);
    }

    public static <E> CloneListIterator<E> cloneListIterator(List<? extends E> list) {
        return new CloneListIterator<E>(list);
    }

    public static <E> CloneListIterator<E> cloneListIterator(List<? extends E> list, CloneListIterator.Mutator<E> mutator) {
        return new CloneListIterator<E>(list, mutator);
    }

    public static <E> CloneListIterator<E> cloneListIterator(E[] array) {
        return new CloneListIterator<E>(array);
    }

    public static <E> CloneListIterator<E> cloneListIterator(E[] array, CloneListIterator.Mutator<E> mutator) {
        return new CloneListIterator<E>(array, mutator);
    }

    public static <E> CompositeIterator<E> compositeIterator(E object, Iterable<? extends E> iterable) {
        return IteratorTools.compositeIterator(object, iterable.iterator());
    }

    public static <E> CompositeIterator<E> compositeIterator(E object, Iterator<? extends E> iterator) {
        return IteratorTools.compositeIterator(new Iterator[]{IteratorTools.singletonIterator(object), iterator});
    }

    public static <E> CompositeIterator<E> compositeIterator(Iterable<? extends E> iterable, E object) {
        return IteratorTools.compositeIterator(iterable.iterator(), object);
    }

    public static <E> CompositeIterator<E> compositeIterator(Iterable<? extends E> ... iterables) {
        return IteratorTools.compositeIterator(Arrays.asList(iterables));
    }

    public static <E> CompositeIterator<E> compositeIterator(Iterable<? extends Iterable<? extends E>> iterables) {
        Transformer<Iterable<E>, Iterator<E>> transformer = IteratorTools.iterableIteratorTransformer();
        return IteratorTools.compositeIterator(IteratorTools.transform(iterables.iterator(), transformer));
    }

    public static <E> CompositeIterator<E> compositeIterator(Iterator<? extends E> iterator, E object) {
        return IteratorTools.compositeIterator(new Iterator[]{iterator, IteratorTools.singletonIterator(object)});
    }

    public static <E> CompositeIterator<E> compositeIterator(Iterator<? extends E> ... iterators) {
        return IteratorTools.compositeIterator(IteratorTools.iterator(iterators));
    }

    public static <E> CompositeIterator<E> compositeIterator(Iterator<? extends Iterator<? extends E>> iterators) {
        return new CompositeIterator(iterators);
    }

    public static <P, E> CompositeIterator<E> compositeIterator(Iterator<? extends P> parents, Transformer<P, Iterator<? extends E>> childrenTransformer) {
        return IteratorTools.compositeIterator(IteratorTools.transform(parents, childrenTransformer));
    }

    public static <P, E> CompositeIterator<E> compositeIterator(Iterable<? extends P> parents, Transformer<P, Iterable<? extends E>> childrenTransformer) {
        return IteratorTools.compositeIterator(IterableTools.transform(parents, childrenTransformer));
    }

    public static <E> CompositeListIterator<E> compositeListIterator(E object, List<E> list) {
        return IteratorTools.compositeListIterator(object, list.listIterator());
    }

    public static <E> CompositeListIterator<E> compositeListIterator(E object, ListIterable<E> iterable) {
        return IteratorTools.compositeListIterator(object, iterable.iterator());
    }

    public static <E> CompositeListIterator<E> compositeListIterator(E object, ListIterator<E> iterator) {
        return IteratorTools.compositeListIterator(new ListIterator[]{IteratorTools.singletonListIterator(object), iterator});
    }

    public static <E> CompositeListIterator<E> compositeListIterator(List<? extends List<E>> lists) {
        Transformer<List<E>, ListIterator<E>> transformer = IteratorTools.listListIteratorTransformer();
        return IteratorTools.compositeListIterator(IteratorTools.transform(lists.listIterator(), transformer));
    }

    public static <E> CompositeListIterator<E> compositeListIterator(List<E> list, E object) {
        return IteratorTools.compositeListIterator(list.listIterator(), object);
    }

    public static <E> CompositeListIterator<E> compositeListIterator(List<E> ... lists) {
        return IteratorTools.compositeListIterator(Arrays.asList(lists));
    }

    public static <E> CompositeListIterator<E> compositeListIterator(ListIterable<E> iterable, E object) {
        return IteratorTools.compositeListIterator(iterable.iterator(), object);
    }

    public static <E> CompositeListIterator<E> compositeListIterator(ListIterable<E> ... iterables) {
        return IteratorTools.compositeListIterator(IterableTools.listIterable(iterables));
    }

    public static <E> CompositeListIterator<E> compositeListIterator(ListIterable<? extends ListIterable<E>> iterables) {
        Transformer<ListIterable<E>, ListIterator<E>> transformer = IteratorTools.listIterableListIteratorTransformer();
        return IteratorTools.compositeListIterator(IteratorTools.transform(iterables.iterator(), transformer));
    }

    public static <P, E> CompositeListIterator<E> compositeListIterator(ListIterable<? extends P> parents, Transformer<P, ListIterable<E>> childrenTransformer) {
        return IteratorTools.compositeListIterator(IterableTools.transform(parents, childrenTransformer));
    }

    public static <E> CompositeListIterator<E> compositeListIterator(ListIterator<E> iterator, E object) {
        return IteratorTools.compositeListIterator(new ListIterator[]{iterator, IteratorTools.singletonListIterator(object)});
    }

    public static <E> CompositeListIterator<E> compositeListIterator(ListIterator<E> ... iterators) {
        return IteratorTools.compositeListIterator(IteratorTools.listIterator(iterators));
    }

    public static <E> CompositeListIterator<E> compositeListIterator(ListIterator<? extends ListIterator<E>> iterators) {
        return new CompositeListIterator(iterators);
    }

    public static <P, E> CompositeListIterator<E> compositeListIterator(ListIterator<? extends P> parents, Transformer<P, ListIterator<E>> childrenTransformer) {
        return IteratorTools.compositeListIterator(IteratorTools.transform(parents, childrenTransformer));
    }

    public static <E> Iterator<E> emptyIterator() {
        return EmptyIterator.instance();
    }

    public static <E> ListIterator<E> emptyListIterator() {
        return EmptyListIterator.instance();
    }

    public static <E> FilteringIterator<E> filteringIterator(Iterable<? extends E> iterable, Filter<E> filter) {
        return new FilteringIterator<E>(iterable, filter);
    }

    public static <E> FilteringIterator<E> filter(Iterator<? extends E> iterator, Filter<E> filter) {
        return new FilteringIterator<E>(iterator, filter);
    }

    public static <E> GraphIterator<E> graphIterator(E root, GraphIterator.MisterRogers<E> misterRogers) {
        return new GraphIterator<E>(root, misterRogers);
    }

    public static <E> GraphIterator<E> graphIterator(E[] roots, GraphIterator.MisterRogers<E> misterRogers) {
        return new GraphIterator<E>(roots, misterRogers);
    }

    public static <E> GraphIterator<E> graphIterator(Iterable<E> roots, GraphIterator.MisterRogers<E> misterRogers) {
        return new GraphIterator<E>(roots, misterRogers);
    }

    public static <E> GraphIterator<E> graphIterator(Iterator<E> roots, GraphIterator.MisterRogers<E> misterRogers) {
        return new GraphIterator<E>(roots, misterRogers);
    }

    public static <E> Transformer<Iterable<? extends E>, Iterator<? extends E>> iterableIteratorTransformer() {
        return ITERABLE_ITERATOR_TRANSFORMER;
    }

    public static <E> EnumerationIterator<E> iterator(Enumeration<E> enumeration) {
        return new EnumerationIterator<E>(enumeration);
    }

    public static <E> ArrayIterator<E> iterator(E ... array) {
        return IteratorTools.iterator(array, 0);
    }

    public static <E> ArrayIterator<E> iterator(E[] array, int start) {
        return IteratorTools.iterator(array, start, array.length);
    }

    public static <E> ArrayIterator<E> iterator(E[] array, int start, int end) {
        return new ArrayIterator<E>(array, start, end);
    }

    public static <E> QueueIterator<E> iterator(Queue<E> queue) {
        return new QueueIterator<E>(queue);
    }

    public static <E> StackIterator<E> iterator(Stack<E> stack) {
        return new StackIterator<E>(stack);
    }

    public static <E1, E2> LateralIteratorWrapper<E1, E2> lateralIterator(Iterable<E1> iterable) {
        return new LateralIteratorWrapper(iterable);
    }

    public static <E1, E2> LateralIteratorWrapper<E1, E2> lateralIterator(Iterator<E1> iterator) {
        return new LateralIteratorWrapper(iterator);
    }

    public static <E1, E2> LateralListIteratorWrapper<E1, E2> lateralListIterator(List<E1> list) {
        return new LateralListIteratorWrapper(list);
    }

    public static <E1, E2> LateralListIteratorWrapper<E1, E2> lateralListIterator(ListIterable<E1> iterable) {
        return new LateralListIteratorWrapper(iterable);
    }

    public static <E1, E2> LateralListIteratorWrapper<E1, E2> lateralListIterator(ListIterator<E1> iterator) {
        return new LateralListIteratorWrapper(iterator);
    }

    public static <E> Transformer<ListIterable<E>, ListIterator<E>> listIterableListIteratorTransformer() {
        return LIST_ITERABLE_LIST_ITERATOR_TRANSFORMER;
    }

    public static <E> ArrayListIterator<E> listIterator(E ... array) {
        return IteratorTools.listIterator(array, 0);
    }

    public static <E> ArrayListIterator<E> listIterator(E[] array, int start) {
        return IteratorTools.listIterator(array, start, array.length);
    }

    public static <E> ArrayListIterator<E> listIterator(E[] array, int start, int end) {
        return new ArrayListIterator<E>(array, start, end);
    }

    public static <E> Transformer<List<E>, ListIterator<E>> listListIteratorTransformer() {
        return LIST_LIST_ITERATOR_TRANSFORMER;
    }

    public static <E> NullElementIterator<E> nullElementIterator(int size) {
        return new NullElementIterator(size);
    }

    public static <E> NullElementListIterator<E> nullElementListIterator(int size) {
        return new NullElementListIterator(size);
    }

    public static <E> PeekableIterator<E> peekableIterator(Iterable<E> iterable) {
        return new PeekableIterator<E>(iterable);
    }

    public static <E> PeekableIterator<E> peekableIterator(Iterator<E> iterator) {
        return new PeekableIterator<E>(iterator);
    }

    public static <E> ReadOnlyCompositeListIterator<E> readOnlyCompositeListIterator(E object, List<? extends E> list) {
        return IteratorTools.readOnlyCompositeListIterator(object, list.listIterator());
    }

    public static <E> ReadOnlyCompositeListIterator<E> readOnlyCompositeListIterator(E object, ListIterable<? extends E> iterable) {
        return IteratorTools.readOnlyCompositeListIterator(object, iterable.iterator());
    }

    public static <E> ReadOnlyCompositeListIterator<E> readOnlyCompositeListIterator(E object, ListIterator<? extends E> iterator) {
        return IteratorTools.readOnlyCompositeListIterator(new ListIterator[]{IteratorTools.singletonListIterator(object), iterator});
    }

    public static <E> ReadOnlyCompositeListIterator<E> readOnlyCompositeListIterator(List<? extends List<? extends E>> lists) {
        Transformer<List<E>, ListIterator<E>> transformer = IteratorTools.readOnlyListListIteratorTransformer();
        return IteratorTools.readOnlyCompositeListIterator(IteratorTools.transform(lists.listIterator(), transformer));
    }

    public static <E> ReadOnlyCompositeListIterator<E> readOnlyCompositeListIterator(List<? extends E> list, E object) {
        return IteratorTools.readOnlyCompositeListIterator(list.listIterator(), object);
    }

    public static <E> ReadOnlyCompositeListIterator<E> readOnlyCompositeListIterator(List<? extends E> ... lists) {
        return IteratorTools.readOnlyCompositeListIterator(Arrays.asList(lists));
    }

    public static <E> ReadOnlyCompositeListIterator<E> readOnlyCompositeListIterator(ListIterable<? extends E> iterable, E object) {
        return IteratorTools.readOnlyCompositeListIterator(iterable.iterator(), object);
    }

    public static <E> ReadOnlyCompositeListIterator<E> readOnlyCompositeListIterator(ListIterable<? extends E> ... iterables) {
        return IteratorTools.readOnlyCompositeListIterator(IterableTools.listIterable(iterables));
    }

    public static <E> ReadOnlyCompositeListIterator<E> readOnlyCompositeListIterator(ListIterable<? extends ListIterable<? extends E>> iterables) {
        Transformer<ListIterable<E>, ListIterator<E>> transformer = IteratorTools.readOnlyListIterableListIteratorTransformer();
        return IteratorTools.readOnlyCompositeListIterator(IteratorTools.transform(iterables.iterator(), transformer));
    }

    public static <E> ReadOnlyCompositeListIterator<E> readOnlyCompositeListIterator(ListIterator<? extends E> iterator, E object) {
        return IteratorTools.readOnlyCompositeListIterator(new ListIterator[]{iterator, IteratorTools.singletonListIterator(object)});
    }

    public static <E> ReadOnlyCompositeListIterator<E> readOnlyCompositeListIterator(ListIterator<? extends E> ... iterators) {
        return IteratorTools.readOnlyCompositeListIterator(IteratorTools.listIterator(iterators));
    }

    public static <E> ReadOnlyCompositeListIterator<E> readOnlyCompositeListIterator(ListIterator<? extends ListIterator<? extends E>> iterators) {
        return new ReadOnlyCompositeListIterator(iterators);
    }

    public static <P, E> ReadOnlyCompositeListIterator<E> readOnlyCompositeListIterator(ListIterator<? extends P> parents, Transformer<P, ListIterator<? extends E>> childrenTransformer) {
        return IteratorTools.readOnlyCompositeListIterator(IteratorTools.transform(parents, childrenTransformer));
    }

    public static <E> Transformer<ListIterable<? extends E>, ListIterator<? extends E>> readOnlyListIterableListIteratorTransformer() {
        return READ_ONLY_LIST_ITERABLE_LIST_ITERATOR_TRANSFORMER;
    }

    public static <E> ReadOnlyIterator<E> readOnlyIterator(Iterable<? extends E> iterable) {
        return new ReadOnlyIterator<E>(iterable);
    }

    public static <E> ReadOnlyIterator<E> readOnlyIterator(Iterator<? extends E> iterator) {
        return new ReadOnlyIterator<E>(iterator);
    }

    public static <E> ReadOnlyListIterator<E> readOnlyListIterator(List<? extends E> list) {
        return new ReadOnlyListIterator<E>(list);
    }

    public static <E> ReadOnlyListIterator<E> readOnlyListIterator(ListIterable<? extends E> iterable) {
        return new ReadOnlyListIterator<E>(iterable);
    }

    public static <E> ReadOnlyListIterator<E> readOnlyListIterator(ListIterator<? extends E> iterator) {
        return new ReadOnlyListIterator<E>(iterator);
    }

    public static <E> Transformer<List<? extends E>, ListIterator<? extends E>> readOnlyListListIteratorTransformer() {
        return READ_ONLY_LIST_LIST_ITERATOR_TRANSFORMER;
    }

    public static <E> RepeatingElementIterator<E> repeatingElementIterator(E element, int size) {
        return new RepeatingElementIterator<E>(element, size);
    }

    public static <E> RepeatingElementListIterator<E> repeatingElementListIterator(E element, int size) {
        return new RepeatingElementListIterator<E>(element, size);
    }

    public static <E> ResultSetIterator<E> resultSetIterator(ResultSet resultSet) {
        return new ResultSetIterator(resultSet);
    }

    public static <E> ResultSetIterator<E> resultSetIterator(ResultSet resultSet, ResultSetIterator.Adapter<E> adapter) {
        return new ResultSetIterator<E>(resultSet, adapter);
    }

    public static <E> ReverseIterator<E> reverseIterator(Iterable<E> iterable) {
        return new ReverseIterator<E>(iterable);
    }

    public static <E> ReverseIterator<E> reverseIterator(Iterable<E> iterable, int iterableSize) {
        return new ReverseIterator<E>(iterable, iterableSize);
    }

    public static <E> ReverseIterator<E> reverseIterator(Iterator<E> iterator) {
        return new ReverseIterator<E>(iterator);
    }

    public static <E> ReverseIterator<E> reverseIterator(Iterator<E> iterator, int iteratorSize) {
        return new ReverseIterator<E>(iterator, iteratorSize);
    }

    public static <E, I extends Iterator<E>> SimultaneousIterator<E> simultaneousIterator(I ... iterators) {
        return new SimultaneousIterator(iterators);
    }

    public static <E, I extends Iterator<E>> SimultaneousIterator<E> simultaneousIterator(Iterable<I> iterables) {
        return new SimultaneousIterator(iterables);
    }

    public static <E, I extends Iterator<E>> SimultaneousIterator<E> simultaneousIterator(Iterable<I> iterables, int iterablesSize) {
        return new SimultaneousIterator(iterables, iterablesSize);
    }

    public static <E, I extends ListIterator<E>> SimultaneousListIterator<E> simultaneousListIterator(I ... iterators) {
        return new SimultaneousListIterator(iterators);
    }

    public static <E, I extends ListIterator<E>> SimultaneousListIterator<E> simultaneousListIterator(Iterable<I> iterables) {
        return new SimultaneousListIterator(iterables);
    }

    public static <E, I extends ListIterator<E>> SimultaneousListIterator<E> simultaneousListIterator(Iterable<I> iterators, int iteratorsSize) {
        return new SimultaneousListIterator(iterators, iteratorsSize);
    }

    public static <E> SingleElementIterator<E> singletonIterator(E value) {
        return new SingleElementIterator<E>(value);
    }

    public static <E> SingleElementListIterator<E> singletonListIterator(E value) {
        return new SingleElementListIterator<E>(value);
    }

    public static <E1, E2 extends E1> SubIteratorWrapper<E1, E2> subIterator(Iterable<E1> iterable) {
        return new SubIteratorWrapper(iterable);
    }

    public static <E1, E2 extends E1> SubIteratorWrapper<E1, E2> subIterator(Iterator<E1> iterator) {
        return new SubIteratorWrapper(iterator);
    }

    public static <E1, E2 extends E1> SubListIteratorWrapper<E1, E2> subListIterator(List<E1> list) {
        return new SubListIteratorWrapper(list);
    }

    public static <E1, E2 extends E1> SubListIteratorWrapper<E1, E2> subListIterator(ListIterable<E1> iterable) {
        return new SubListIteratorWrapper(iterable);
    }

    public static <E1, E2 extends E1> SubListIteratorWrapper<E1, E2> subListIterator(ListIterator<E1> iterator) {
        return new SubListIteratorWrapper(iterator);
    }

    public static <E> Iterator<E> SuperIteratorWrapper(Iterable<? extends E> iterable) {
        return new SuperIteratorWrapper<E>(iterable);
    }

    public static <E> Iterator<E> SuperIteratorWrapper(Iterator<? extends E> iterator) {
        return new SuperIteratorWrapper<E>(iterator);
    }

    public static <E> ListIterator<E> SuperListIteratorWrapper(List<? extends E> list) {
        return new SuperListIteratorWrapper<E>(list);
    }

    public static <E> ListIterator<E> SuperListIteratorWrapper(ListIterable<? extends E> iterable) {
        return new SuperListIteratorWrapper<E>(iterable);
    }

    public static <E> ListIterator<E> SuperListIteratorWrapper(ListIterator<? extends E> iterator) {
        return new SuperListIteratorWrapper<E>(iterator);
    }

    public static <E> SynchronizedIterator<E> synchronizedIterator(Iterable<? extends E> iterable) {
        return new SynchronizedIterator<E>(iterable);
    }

    public static <E> SynchronizedIterator<E> synchronizedIterator(Iterable<? extends E> iterable, Object mutex) {
        return new SynchronizedIterator<E>(iterable, mutex);
    }

    public static <E> SynchronizedIterator<E> synchronizedIterator(Iterator<? extends E> iterator) {
        return new SynchronizedIterator<E>(iterator);
    }

    public static <E> SynchronizedIterator<E> synchronizedIterator(Iterator<? extends E> iterator, Object mutex) {
        return new SynchronizedIterator<E>(iterator, mutex);
    }

    public static <E> SynchronizedListIterator<E> synchronizedListIterator(List<E> list) {
        return new SynchronizedListIterator<E>(list);
    }

    public static <E> SynchronizedListIterator<E> synchronizedListIterator(ListIterable<E> iterable) {
        return new SynchronizedListIterator<E>(iterable);
    }

    public static <E> SynchronizedListIterator<E> synchronizedListIterator(ListIterable<E> iterable, Object mutex) {
        return new SynchronizedListIterator<E>(iterable, mutex);
    }

    public static <E> SynchronizedListIterator<E> synchronizedListIterator(ListIterator<E> iterator) {
        return new SynchronizedListIterator<E>(iterator);
    }

    public static <E> SynchronizedListIterator<E> synchronizedListIterator(ListIterator<E> iterator, Object mutex) {
        return new SynchronizedListIterator<E>(iterator, mutex);
    }

    public static <E1, E2> TransformationIterator<E1, E2> transformationIterator(Iterable<? extends E1> iterable, Transformer<E1, ? extends E2> transformer) {
        return new TransformationIterator<E1, E2>(iterable, transformer);
    }

    public static <E1, E2> TransformationIterator<E1, E2> transform(Iterator<? extends E1> iterator, Transformer<E1, ? extends E2> transformer) {
        return new TransformationIterator<E1, E2>(iterator, transformer);
    }

    public static <E1, T1 extends E1, E2> TransformationListIterator<E1, E2> transformationListIterator(List<? extends E1> list, Transformer<E1, ? extends E2> transformer) {
        return new TransformationListIterator<E1, E2>(list, transformer);
    }

    public static <E1, E2> TransformationListIterator<E1, E2> transformationListIterator(ListIterable<? extends E1> iterable, Transformer<E1, ? extends E2> transformer) {
        return new TransformationListIterator<E1, E2>(iterable, transformer);
    }

    public static <E1, E2> TransformationListIterator<E1, E2> transform(ListIterator<? extends E1> iterator, Transformer<E1, ? extends E2> transformer) {
        return new TransformationListIterator<E1, E2>(iterator, transformer);
    }

    public static <E> TreeIterator<E> treeIterator(E root, Transformer<E, Iterator<? extends E>> transformer) {
        return IteratorTools.treeIterator(new SingleElementIterator<E>(root), transformer);
    }

    public static <E> TreeIterator<E> treeIterator(E[] roots, Transformer<E, Iterator<? extends E>> transformer) {
        return IteratorTools.treeIterator(new ArrayIterator<E>(roots), transformer);
    }

    public static <E> TreeIterator<E> treeIterator(Iterable<? extends E> roots, Transformer<E, Iterator<? extends E>> transformer) {
        return IteratorTools.treeIterator(roots.iterator(), transformer);
    }

    public static <E> TreeIterator<E> treeIterator(Iterator<? extends E> roots, Transformer<E, Iterator<? extends E>> transformer) {
        return new TreeIterator<E>(roots, transformer);
    }

    private IteratorTools() {
        throw new UnsupportedOperationException();
    }

    static class IterableIteratorTransformer<E>
    implements Transformer<Iterable<E>, Iterator<E>> {
        IterableIteratorTransformer() {
        }

        @Override
        public Iterator<E> transform(Iterable<E> iterable) {
            return iterable.iterator();
        }
    }

    static class ListIterableListIteratorTransformer<E>
    implements Transformer<ListIterable<E>, ListIterator<E>> {
        ListIterableListIteratorTransformer() {
        }

        @Override
        public ListIterator<E> transform(ListIterable<E> list) {
            return list.iterator();
        }
    }

    static class ListListIteratorTransformer<E>
    implements Transformer<List<E>, ListIterator<E>> {
        ListListIteratorTransformer() {
        }

        @Override
        public ListIterator<E> transform(List<E> list) {
            return list.listIterator();
        }
    }

    static class ReadOnlyListIterableListIteratorTransformer<E>
    implements Transformer<ListIterable<? extends E>, ListIterator<? extends E>> {
        ReadOnlyListIterableListIteratorTransformer() {
        }

        @Override
        public ListIterator<? extends E> transform(ListIterable<? extends E> iterable) {
            return IteratorTools.readOnlyListIterator(iterable);
        }
    }

    static class ReadOnlyListListIteratorTransformer<E>
    implements Transformer<List<? extends E>, ListIterator<? extends E>> {
        ReadOnlyListListIteratorTransformer() {
        }

        @Override
        public ListIterator<? extends E> transform(List<? extends E> list) {
            return IteratorTools.readOnlyListIterator(list);
        }
    }
}

