/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.Range;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.iterator.ReadOnlyListIterator;
import org.eclipse.persistence.tools.utility.model.event.ListAddEvent;
import org.eclipse.persistence.tools.utility.model.event.ListChangeEvent;
import org.eclipse.persistence.tools.utility.model.event.ListClearEvent;
import org.eclipse.persistence.tools.utility.model.event.ListMoveEvent;
import org.eclipse.persistence.tools.utility.model.event.ListRemoveEvent;
import org.eclipse.persistence.tools.utility.model.event.ListReplaceEvent;
import org.eclipse.persistence.tools.utility.model.value.ListValueModel;
import org.eclipse.persistence.tools.utility.model.value.ListValueModelWrapper;

public class SortedListValueModelWrapper<E>
extends ListValueModelWrapper<E>
implements ListValueModel<E> {
    protected Comparator<E> comparator;
    protected final ArrayList<E> sortedList;

    public SortedListValueModelWrapper(ListValueModel<? extends E> listHolder, Comparator<E> comparator) {
        super(listHolder);
        this.comparator = comparator;
        this.sortedList = new ArrayList(listHolder.size());
    }

    public SortedListValueModelWrapper(ListValueModel<? extends E> listHolder) {
        this(listHolder, null);
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator<E>(this.sortedList);
    }

    @Override
    public E get(int index) {
        return this.sortedList.get(index);
    }

    @Override
    public int size() {
        return this.sortedList.size();
    }

    @Override
    public Object[] toArray() {
        return this.sortedList.toArray();
    }

    public void setComparator(Comparator<E> comparator) {
        this.comparator = comparator;
        this.sortList();
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.buildSortedList();
    }

    @Override
    protected void disengageModel() {
        super.disengageModel();
        this.sortedList.clear();
    }

    protected void buildSortedList() {
        int size = this.listModel.size();
        if (size != 0) {
            this.buildSortedList(size);
        }
    }

    protected void buildSortedList(int size) {
        this.sortedList.ensureCapacity(size);
        for (Object each : this.listModel) {
            this.sortedList.add(each);
        }
        Collections.sort(this.sortedList, this.comparator);
    }

    @Override
    protected void itemsAdded(ListAddEvent event) {
        this.addItemsToList(this.getItems(event), this.sortedList, "list values");
        this.sortList();
    }

    @Override
    protected void itemsRemoved(ListRemoveEvent event) {
        this.removeItemsFromList(this.getItems(event), this.sortedList, "list values");
    }

    @Override
    protected void itemsReplaced(ListReplaceEvent event) {
        this.removeItemsFromList(this.getOldItems(event), this.sortedList, "list values");
        this.addItemsToList(this.getNewItems(event), this.sortedList, "list values");
        this.sortList();
    }

    @Override
    protected void itemsMoved(ListMoveEvent event) {
    }

    @Override
    protected void listCleared(ListClearEvent event) {
        this.clearList(this.sortedList, "list values");
    }

    @Override
    protected void listChanged(ListChangeEvent event) {
        int size = this.listModel.size();
        if (size == 0) {
            if (!this.sortedList.isEmpty()) {
                this.clearList(this.sortedList, "list values");
            }
        } else if (this.sortedList.isEmpty()) {
            this.buildSortedList(size);
            this.fireItemsAdded("list values", 0, this.sortedList);
        } else {
            this.sortedList.clear();
            this.buildSortedList(size);
            this.fireListChanged("list values", this.sortedList);
        }
    }

    protected void sortList() {
        ArrayList unsortedList = (ArrayList)this.sortedList.clone();
        Collections.sort(this.sortedList, this.comparator);
        Range diffRange = ListTools.identityDifferenceRange(unsortedList, this.sortedList);
        if (diffRange.size > 0) {
            List unsortedItems = unsortedList.subList(diffRange.start, diffRange.end + 1);
            List<E> sortedItems = this.sortedList.subList(diffRange.start, diffRange.end + 1);
            this.fireItemsReplaced("list values", diffRange.start, sortedItems, unsortedItems);
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.sortedList);
    }
}

