/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

/**
 * This interface and inherited behavior describes the configurable properties for a mapping
 * in the ORM xml that has a generated value.
 *
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see Basic
 * @see Id
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html,
 * persistence specificaton
 *
 * @version 2.5
 * @author John Bracken
 */
public interface ExternalGeneratedMapping extends ExternalMapping {

	/**
	 * Creates a new generated value for this ID mapping replacing the old one.
	 */
	ExternalEntityIDGeneratedValue addGeneratedValue();

	/**
	 * Creates a new sequence generator for this ID mapping.
	 */
	ExternalSequenceGenerator addSequenceGenerator();

	/**
	 * Creates a new table generator for this ID mapping.
	 */
	ExternalTableGenerator addTableGenerator();

	/**
	 * Returns the generated value for this ID mapping.
	 */
	ExternalEntityIDGeneratedValue getGeneratedValue();

	/**
	 * Returns the sequence generator to be used with this ID mapping.
	 */
	ExternalSequenceGenerator getSequenceGenerator();

	/**
	 * Returns the table generator to be used with this ID mapping.
	 */
	ExternalTableGenerator getTableGenerator();

	/**
	 * Removes the generated value from the mapping.
	 */
	void removeGeneratedValue();

	/**
	 * Removes the sequence generator from the mapping.
	 */
	void removeSequenceGenerator();

	/**
	 * Removes the table generator from the mapping.
	 */
	void removeTableGenerator();

	/**
	 * Creates a new sequence generator to be used with this ID mapping replacing the old one.
	 */
	void setSequenceGenerator(String generatorName);

	/**
	 * Creates new table generator to be used with this ID mapping replacing the old one.
	 */
	void setTableGenerator(String generatorName);
}