/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.iterable;

import java.io.Serializable;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.iterator.EmptyListIterator;

/**
 * An <code>EmptyListIterable</code> is just that.
 * Maybe just a touch better-performing than {@link java.util.Collections#EMPTY_LIST}
 * since we don't create a new {@link java.util.Iterator} every time
 * {@link #iterator()} is called. (Not sure why they do that....)
 *
 * @param <E> the type of elements returned by the list iterable's list iterator
 *
 * @see EmptyListIterator
 * @see EmptyIterable
 */
@SuppressWarnings("nls")
public final class EmptyListIterable<E>
	implements ListIterable<E>, Serializable
{
	// singleton
	@SuppressWarnings("rawtypes")
	private static final ListIterable INSTANCE = new EmptyListIterable();

	/**
	 * Return the singleton.
	 */
	@SuppressWarnings("unchecked")
	public static <T> ListIterable<T> instance() {
		return INSTANCE;
	}

	/**
	 * Ensure single instance.
	 */
	private EmptyListIterable() {
		super();
	}

	@Override
	public ListIterator<E> iterator() {
		return EmptyListIterator.instance();
	}

	@Override
	public String toString() {
		return "[]";
	}

	private static final long serialVersionUID = 1L;
	private Object readResolve() {
		// replace this object with the singleton
		return INSTANCE;
	}
}