/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.reference;

/**
 * Convenience abstract class for modifiable boolean reference implementations.
 * Subclasses need only implement<ul>
 * <li>{@link #getValue()}
 * <li>{@link #setValue(boolean)}
 * </ul>
 */
public abstract class AbstractModifiableBooleanReference
	extends AbstractBooleanReference
	implements ModifiableBooleanReference
{
	protected AbstractModifiableBooleanReference() {
		super();
	}

	@Override
	public boolean flip() {
		return this.setValue( ! this.getValue());
	}

	@Override
	public boolean setNot(boolean value) {
		return this.setValue( ! value);
	}

	@Override
	public boolean setTrue() {
		return this.setValue(true);
	}

	@Override
	public boolean setFalse() {
		return this.setValue(false);
	}
}