/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.iterator.SuperIteratorWrapper;

@SuppressWarnings("nls")
public class SuperIteratorWrapperTests extends TestCase {

	public SuperIteratorWrapperTests(String name) {
		super(name);
	}

	public void testIterator() {
		ArrayList<String> list = new ArrayList<String>();
		list.add("foo");
		list.add("bar");
		list.add("baz");
		String concat = "";
		for (Iterator<String> stream = list.iterator(); stream.hasNext(); ) {
			concat += stream.next();
		}
		assertEquals("foobarbaz", concat);

		Iterator<Object> iterator = new SuperIteratorWrapper<Object>(list);
		concat = "";
		while (iterator.hasNext()) {
			Object next = iterator.next();
			if (next.equals("bar")) {
				iterator.remove();
			} else {
				concat += next;
			}
		}
		assertEquals("foobaz", concat);
		assertEquals(2, list.size());
		assertFalse(list.contains("bar"));
	}
}