/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.repreparation;

import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class AddJoinedAttributeTest
extends AutoVerifyTestCase {
    private ReadAllQuery query;
    private Vector employees;
    private static String EXPECTED_SQL = "SELECT t1.EMP_ID, t2.EMP_ID, t1.F_NAME, t1.GENDER, t1.L_NAME, t2.SALARY, t1.START_TIME, t1.END_TIME, t1.END_DATE, t1.START_DATE, t1.ADDR_ID, t1.MANAGER_ID, t1.VERSION, t0.ADDRESS_ID, t0.CITY, t0.COUNTRY, t0.P_CODE, t0.PROVINCE, t0.STREET FROM ADDRESS t0, SALARY t2, EMPLOYEE t1 WHERE ((t2.EMP_ID = t1.EMP_ID) AND (t0.ADDRESS_ID = t1.ADDR_ID))";

    public AddJoinedAttributeTest() {
        this.setDescription("Test if SQL is reprepared the second time");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.query = new ReadAllQuery(Employee.class);
        this.employees = (Vector)this.getSession().executeQuery((DatabaseQuery)this.query);
    }

    public void test() {
        this.query.addJoinedAttribute("address");
        this.employees = (Vector)this.getSession().executeQuery((DatabaseQuery)this.query);
    }

    public void verify() {
        if (!this.query.getCall().getSQLString().equals(EXPECTED_SQL)) {
            throw new TestErrorException("AddJoinedAttributeTest failed. \n [Expected] " + EXPECTED_SQL + "\n[Found] " + this.query.getCall().getSQLString());
        }
    }
}

