/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.repreparation;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class AddPartialAttributeForCustomSQLTest
extends TestCase {
    static String lastName = "AddPartialAttributeForCustomSQLTest";

    public AddPartialAttributeForCustomSQLTest() {
        this.setDescription("Test PartialAttrubute function on custom SQL for ReadAllQuery, ReadObjectQuery");
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        try {
            Employee empOne = (Employee)this.getSession().executeQuery((DatabaseQuery)this.createReadObjectQueryOne());
            Employee empTwo = (Employee)this.getSession().executeQuery((DatabaseQuery)this.createReadObjectQueryTwo());
            Vector empsOne = (Vector)this.getSession().executeQuery((DatabaseQuery)this.createReadAllQueryOne());
            Vector empsTwo = (Vector)this.getSession().executeQuery((DatabaseQuery)this.createReadAllQueryTwo());
            Vector emps = (Vector)this.getSession().executeQuery((DatabaseQuery)this.createReportQuery());
        }
        catch (Exception e) {
            throw new TestErrorException("AddPartialAttributeForCustomSQLTest failed.");
        }
    }

    protected ReadObjectQuery createReadObjectQueryOne() {
        ReadObjectQuery query = new ReadObjectQuery(Employee.class, (Call)new SQLCall("SELECT t1.EMP_ID, t1.L_NAME, t1.F_NAME, t0.CITY FROM ADDRESS t0, SALARY t2, EMPLOYEE t1 WHERE ((t2.EMP_ID = t1.EMP_ID) AND (t0.ADDRESS_ID = t1.ADDR_ID))"));
        query.dontMaintainCache();
        query.addPartialAttribute("lastName");
        query.addPartialAttribute("firstName");
        query.addPartialAttribute(query.getExpressionBuilder().get("address").get("city"));
        return query;
    }

    protected ReadObjectQuery createReadObjectQueryTwo() {
        ReadObjectQuery query = new ReadObjectQuery(Employee.class, (Call)new SQLCall("SELECT t1.EMP_ID, t1.L_NAME, t1.F_NAME, t0.ADDRESS_ID, t0.P_CODE, t0.COUNTRY, t0.PROVINCE, t0.CITY, t0.STREET FROM ADDRESS t0, SALARY t2, EMPLOYEE t1 WHERE ((t2.EMP_ID = t1.EMP_ID) AND (t0.ADDRESS_ID = t1.ADDR_ID))"));
        query.dontMaintainCache();
        query.addPartialAttribute("lastName");
        query.addPartialAttribute("firstName");
        query.addPartialAttribute(query.getExpressionBuilder().get("address"));
        return query;
    }

    protected ReadAllQuery createReadAllQueryOne() {
        ReadAllQuery query = new ReadAllQuery(Employee.class, (Call)new SQLCall("SELECT t1.EMP_ID, t1.L_NAME, t1.F_NAME, t0.CITY FROM ADDRESS t0, SALARY t2, EMPLOYEE t1 WHERE ((t2.EMP_ID = t1.EMP_ID) AND (t0.ADDRESS_ID = t1.ADDR_ID))"));
        query.dontMaintainCache();
        query.addPartialAttribute("lastName");
        query.addPartialAttribute("firstName");
        query.addPartialAttribute(query.getExpressionBuilder().get("address").get("city"));
        return query;
    }

    protected ReadAllQuery createReadAllQueryTwo() {
        ReadAllQuery query = new ReadAllQuery(Employee.class, (Call)new SQLCall("SELECT t1.EMP_ID, t1.L_NAME, t1.F_NAME, t0.ADDRESS_ID, t0.P_CODE, t0.COUNTRY, t0.PROVINCE, t0.CITY, t0.STREET FROM ADDRESS t0, SALARY t2, EMPLOYEE t1 WHERE ((t2.EMP_ID = t1.EMP_ID) AND (t0.ADDRESS_ID = t1.ADDR_ID))"));
        query.dontMaintainCache();
        query.addPartialAttribute("lastName");
        query.addPartialAttribute("firstName");
        query.addPartialAttribute(query.getExpressionBuilder().get("address"));
        return query;
    }

    protected ReportQuery createReportQuery() {
        ReportQuery query = new ReportQuery();
        query.setReferenceClass(Employee.class);
        query.setCall((Call)new SQLCall("SELECT t1.EMP_ID, t1.F_NAME, t1.L_NAME FROM ADDRESS t0, SALARY t2, EMPLOYEE t1 WHERE (((t0.PROVINCE = ?) AND (t2.EMP_ID = t1.EMP_ID)) AND (t0.ADDRESS_ID = t1.ADDR_ID))"));
        query.dontMaintainCache();
        query.addAttribute("firstName");
        query.addAttribute("lastName");
        query.addJoinedAttribute("address");
        query.setSelectionCriteria(new ExpressionBuilder().get("address").get("province").equal((Object)"ONT"));
        return query;
    }
}

