/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.memory;

import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.spi.PersistenceProvider;
import junit.framework.Test;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.MemoryRegressionTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.models.jpa.performance.Address;
import org.eclipse.persistence.testing.models.jpa.performance.Employee;
import org.eclipse.persistence.testing.models.jpa.performance.EmployeeTableCreator;
import org.eclipse.persistence.testing.models.jpa.performance.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.performance.PhoneNumber;

public class JPAMemoryRegressionModel
extends TestModel {
    public JPAMemoryRegressionModel() {
        this.setDescription("Memory tests that compare JPA memory usage.");
    }

    public void addTests() {
        this.addTest((Test)this.buildReadTest());
        this.addTest((Test)this.buildInsertTest());
        this.addTest((Test)this.buildUpdateTest());
        this.addTest((Test)this.buildBootstrapTest());
    }

    public void setup() {
        this.setupProvider();
        this.getSession().logMessage(this.getExecutor().getEntityManagerFactory().getClass().toString());
        System.out.println(this.getExecutor().getEntityManagerFactory().getClass().toString());
        EntityManager manager = this.getExecutor().createEntityManager();
        try {
            new EmployeeTableCreator().replaceTables((DatabaseSession)((JpaEntityManager)manager).getServerSession());
        }
        catch (ClassCastException cast) {
            new EmployeeTableCreator().replaceTables(this.getDatabaseSession());
        }
        manager.getTransaction().begin();
        for (int j = 0; j < 1000; ++j) {
            Employee empInsert = new Employee();
            empInsert.setFirstName("Brendan");
            empInsert.setMale();
            empInsert.setLastName("" + j + "");
            empInsert.setSalary(100000);
            EmploymentPeriod employmentPeriod = new EmploymentPeriod();
            Date startDate = Helper.dateFromString((String)"1901-12-31");
            Date endDate = Helper.dateFromString((String)"1895-01-01");
            employmentPeriod.setEndDate(startDate);
            employmentPeriod.setStartDate(endDate);
            empInsert.setPeriod(employmentPeriod);
            empInsert.setAddress(new Address());
            empInsert.getAddress().setCity("Nepean");
            empInsert.getAddress().setPostalCode("N5J2N5");
            empInsert.getAddress().setProvince("ON");
            empInsert.getAddress().setStreet("1111 Mountain Blvd. Floor 13, suite " + j);
            empInsert.getAddress().setCountry("Canada");
            empInsert.addPhoneNumber(new PhoneNumber("Work Fax", "613", "2255943"));
            empInsert.addPhoneNumber(new PhoneNumber("Home", "613", "2224599"));
            manager.persist((Object)empInsert);
        }
        manager.getTransaction().commit();
        ((JpaEntityManager)manager).getServerSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        manager.close();
    }

    public void setupProvider() {
        String providerClass = "org.eclipse.persistence.jpa.PersistenceProvider";
        PersistenceProvider provider = null;
        try {
            provider = (PersistenceProvider)Class.forName(providerClass).newInstance();
        }
        catch (Exception error) {
            throw new TestProblemException("Failed to create persistence provider.", (Throwable)error);
        }
        Map properties = this.getPersistenceProperties();
        this.getExecutor().setEntityManagerFactory(provider.createEntityManagerFactory("performance", properties));
    }

    public Map getPersistenceProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.jdbc.driver", this.getSession().getLogin().getDriverClassName());
        properties.put("eclipselink.jdbc.url", this.getSession().getLogin().getConnectionString());
        properties.put("eclipselink.jdbc.user", this.getSession().getLogin().getUserName());
        properties.put("eclipselink.jdbc.password", this.getSession().getLogin().getPassword());
        properties.put("eclipselink.logging.level", this.getSession().getSessionLog().getLevelString());
        properties.put("eclipselink.jdbc.cache-statements", "true");
        return properties;
    }

    public TestCase buildBootstrapTest() {
        MemoryRegressionTestCase test = new MemoryRegressionTestCase(){

            public void startTest() {
                this.getExecutor().getEntityManagerFactory().close();
                this.getExecutor().setEntityManagerFactory(null);
            }

            public void test() {
                EntityManager manager = this.createEntityManager();
                Query query = manager.createQuery("Select e from Employee e");
                query.getResultList();
                manager.close();
            }
        };
        test.setName("BootstrapMemoryTest");
        return test;
    }

    public TestCase buildInsertTest() {
        MemoryRegressionTestCase test = new MemoryRegressionTestCase(){

            public void startTest() {
                EntityManager manager = this.createEntityManager();
                ((JpaEntityManager)manager).getServerSession().getIdentityMapAccessor().initializeAllIdentityMaps();
                manager.close();
            }

            public void test() {
                for (int count = 0; count < 500; ++count) {
                    EntityManager manager = this.createEntityManager();
                    manager.getTransaction().begin();
                    Employee employee = new Employee();
                    employee.setFirstName("NewGuy");
                    employee.setLastName("Smith");
                    manager.persist((Object)employee);
                    manager.getTransaction().commit();
                    manager.close();
                }
            }

            public void endTest() {
                EntityManager manager = this.createEntityManager();
                manager.getTransaction().begin();
                manager.createNativeQuery("Delete from P_EMPLOYEE where F_NAME = 'NewGuy'").executeUpdate();
                manager.getTransaction().commit();
                ((JpaEntityManager)manager).getServerSession().getIdentityMapAccessor().initializeAllIdentityMaps();
                manager.close();
            }
        };
        test.setName("InsertMemoryTest");
        return test;
    }

    public TestCase buildUpdateTest() {
        MemoryRegressionTestCase test = new MemoryRegressionTestCase(){

            public void startTest() {
                EntityManager manager = this.createEntityManager();
                ((JpaEntityManager)manager).getServerSession().getIdentityMapAccessor().initializeAllIdentityMaps();
                manager.close();
            }

            public void test() {
                EntityManager manager = this.createEntityManager();
                Query query = manager.createQuery("Select e from Employee e");
                List employees = query.getResultList();
                for (Employee employee : employees) {
                    manager.getTransaction().begin();
                    employee.setFirstName("UpdatedGuy");
                    manager.getTransaction().commit();
                }
                manager.close();
            }

            public void endTest() {
                EntityManager manager = this.createEntityManager();
                ((JpaEntityManager)manager).getServerSession().getIdentityMapAccessor().initializeAllIdentityMaps();
                manager.close();
            }
        };
        test.setName("UpdateMemoryTest");
        return test;
    }

    public TestCase buildReadTest() {
        MemoryRegressionTestCase test = new MemoryRegressionTestCase(){
            List results;

            public void startTest() {
                EntityManager manager = this.createEntityManager();
                ((JpaEntityManager)manager).getServerSession().getIdentityMapAccessor().initializeAllIdentityMaps();
                manager.close();
            }

            public void test() {
                EntityManager manager = this.createEntityManager();
                Query query = manager.createQuery("Select e from Employee e");
                this.results = query.getResultList();
                manager.close();
            }

            public void endTest() {
                this.results = null;
                EntityManager manager = this.createEntityManager();
                ((JpaEntityManager)manager).getServerSession().getIdentityMapAccessor().initializeAllIdentityMaps();
                manager.close();
            }
        };
        test.setName("ReadMemoryTest");
        return test;
    }
}

