/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.listener.awt;

import java.awt.EventQueue;
import org.eclipse.persistence.tools.utility.RunnableAdapter;
import org.eclipse.persistence.tools.utility.collection.SynchronizedQueue;
import org.eclipse.persistence.tools.utility.model.event.StateChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.StateChangeListener;

public final class AWTStateChangeListenerWrapper
implements StateChangeListener {
    private final StateChangeListener listener;
    private final SynchronizedQueue<StateChangeEvent> events = new SynchronizedQueue();

    public AWTStateChangeListenerWrapper(StateChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    @Override
    public void stateChanged(StateChangeEvent event) {
        this.events.enqueue(event);
        if (this.isExecutingOnUIThread()) {
            this.forwardEvents();
        } else {
            this.executeOnEventQueue(new ForwardEventsRunnable());
        }
    }

    private boolean isExecutingOnUIThread() {
        return EventQueue.isDispatchThread();
    }

    private void executeOnEventQueue(Runnable r) {
        EventQueue.invokeLater(r);
    }

    void forwardEvents() {
        for (StateChangeEvent event : this.events.drain()) {
            this.listener.stateChanged(event);
        }
    }

    public String toString() {
        return "AWT(" + this.listener.toString() + ')';
    }

    class ForwardEventsRunnable
    extends RunnableAdapter {
        ForwardEventsRunnable() {
        }

        @Override
        public void run() {
            AWTStateChangeListenerWrapper.this.forwardEvents();
        }
    }
}

