/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.enumeration;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.ClassTools;
import org.eclipse.persistence.tools.utility.enumeration.EnumerationTools;

public class EnumerationToolsTests
extends TestCase {
    public EnumerationToolsTests(String name) {
        super(name);
    }

    public void testContainsEnumerationObject_String() {
        Vector<String> v = this.buildStringVector1();
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.contains(v.elements(), (Object)"one"));
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.contains(v.elements(), null));
        v.add(null);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.contains(v.elements(), null));
    }

    public void testContainsEnumerationObject_Object() {
        Vector<String> c = new Vector<String>();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        String one = "one";
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.contains(c.elements(), (Object)one));
        EnumerationToolsTests.assertFalse((boolean)EnumerationTools.contains(c.elements(), null));
        c.add(null);
        EnumerationToolsTests.assertTrue((boolean)EnumerationTools.contains(c.elements(), null));
    }

    public void testConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ClassTools.newInstance(EnumerationTools.class);
                EnumerationToolsTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        EnumerationToolsTests.assertTrue((boolean)exCaught);
    }

    private Vector<String> buildStringVector1() {
        Vector<String> v = new Vector<String>();
        this.addToCollection1(v);
        return v;
    }

    private void addToCollection1(Collection<? super String> c) {
        c.add("zero");
        c.add("one");
        c.add("two");
    }
}

