/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalAssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalAttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalEmbeddedMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlField;
import org.eclipse.persistence.tools.mapping.orm.dom.AssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.dom.AttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSqlField;
import org.eclipse.persistence.tools.mapping.orm.dom.NonTransientMapping;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class EmbeddedMapping
extends NonTransientMapping
implements ExternalEmbeddedMapping {
    static final String ACCESS = "access";
    static final String EMBEDDED = "embedded";

    EmbeddedMapping(EmbeddableEntity parent, int index) {
        super(parent, index);
    }

    @Override
    public ExternalAssociationOverride addAssociationOverride(int index) {
        AssociationOverride associationOverride = this.buildAssociationOverride(index);
        associationOverride.addSelf();
        return associationOverride;
    }

    @Override
    public ExternalAttributeOverride addAttributeOverride(int index) {
        AttributeOverride attributeOverride = this.buildAttributeOverride(index);
        attributeOverride.addSelf();
        return attributeOverride;
    }

    @Override
    public ListIterable<ExternalAssociationOverride> associationOverrides() {
        int count = this.associationOverridesSize();
        ArrayList<AssociationOverride> associationOverrides = new ArrayList<AssociationOverride>(count);
        int index = count;
        while (--index >= 0) {
            AssociationOverride associationOverride = this.buildAssociationOverride(index);
            associationOverrides.add(0, associationOverride);
        }
        return new ListListIterable(associationOverrides);
    }

    @Override
    public int associationOverridesSize() {
        return this.getChildrenSize("association-override");
    }

    @Override
    public ListIterable<ExternalAttributeOverride> attributeOverrides() {
        int count = this.attributeOverridesSize();
        ArrayList<AttributeOverride> attributeOverrides = new ArrayList<AttributeOverride>(count);
        int index = count;
        while (--index >= 0) {
            AttributeOverride attributeOverride = this.buildAttributeOverride(index);
            attributeOverrides.add(0, attributeOverride);
        }
        return new ListListIterable(attributeOverrides);
    }

    @Override
    public int attributeOverridesSize() {
        return this.getChildrenSize("attribute-override");
    }

    private AssociationOverride buildAssociationOverride(int index) {
        return new AssociationOverride(this, index);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add(ACCESS);
        names.add("attribute-type");
        return names;
    }

    private AttributeOverride buildAttributeOverride(int index) {
        return new AttributeOverride(this, index);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("attribute-override");
        names.add("association-override");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private ExternalNoSqlField buildNoSqlField() {
        return new NoSqlField(this);
    }

    @Override
    public ExternalAssociationOverride getAssociationOverride(int index) {
        Element element = this.getChild("association-override", index);
        if (element == null) {
            return null;
        }
        return this.buildAssociationOverride(index);
    }

    @Override
    public ExternalAttributeOverride getAttributeOverride(int index) {
        Element element = this.getChild("attribute-override", index);
        if (element == null) {
            return null;
        }
        return this.buildAttributeOverride(index);
    }

    @Override
    protected String getElementName() {
        return EMBEDDED;
    }

    @Override
    public String getNoSqlField() {
        ExternalNoSqlField field = this.buildNoSqlField();
        return field.getName();
    }

    @Override
    public final boolean isEmbeddedMapping() {
        return true;
    }

    @Override
    public void removeAssociationOverride(int index) {
        AssociationOverride associationOverride = this.buildAssociationOverride(index);
        associationOverride.removeSelf();
    }

    @Override
    public void removeAttributeOverride(int index) {
        AttributeOverride attributeOverride = this.buildAttributeOverride(index);
        attributeOverride.removeSelf();
    }

    @Override
    public void setAttributeType(String attributeType) {
        this.setAttribute("attribute-type", attributeType);
    }

    @Override
    public void setNoSqlField(String field) {
        ExternalNoSqlField noSqlField = this.buildNoSqlField();
        noSqlField.setName(field);
    }
}

