/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.w3c.dom.Element;

class JoinColumn
extends AbstractColumn
implements ExternalJoinColumn {
    private final String elementName;
    private final int index;
    static final String BASE = "base";
    static final String CONTIGUOUS = "contiguous";
    static final String JOIN_COLUMN = "join-column";
    static final String REFERENCED_COLUMN_NAME = "referenced-column-name";

    JoinColumn(AbstractExternalForm parent, int index) {
        this(parent, JOIN_COLUMN, index);
    }

    JoinColumn(AbstractExternalForm parent, String elementName, int index) {
        super(parent);
        this.index = index;
        this.elementName = elementName;
    }

    @Override
    protected final Element addSelf(String elementName, List<String> elementNamesOrder) {
        return this.addChild(this.getParent(), elementName, this.index, elementNamesOrder);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add(REFERENCED_COLUMN_NAME);
        names.add("unique");
        names.add("nullable");
        names.add("insertable");
        names.add("updatable");
        names.add("column-definition");
        names.add(CONTIGUOUS);
        names.add(BASE);
        names.add("table");
        return names;
    }

    @Override
    public final Integer getBase() {
        return this.getIntegerAttribute(BASE);
    }

    @Override
    public final Element getElement() {
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return this.elementName;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final String getReferenceColumnName() {
        return this.getAttribute(REFERENCED_COLUMN_NAME);
    }

    @Override
    public final Boolean isContiguous() {
        return this.getBooleanAttribute(CONTIGUOUS);
    }

    @Override
    public final void removeSelf() {
        this.removeChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public final void setBase(Integer base) {
        this.setAttribute(BASE, base);
    }

    @Override
    public final void setContiguous(Boolean contiguous) {
        this.setAttribute(CONTIGUOUS, contiguous);
    }

    @Override
    public final void setReferenceColumnName(String name) {
        this.setAttribute(REFERENCED_COLUMN_NAME, name);
    }
}

