/*******************************************************************************
 * Copyright (c) 2007, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.model.value;

import java.io.Serializable;
import org.eclipse.persistence.tools.utility.model.AbstractModel;

/**
 * A property value model for when you
 * don't need to support a value.
 * <p>
 * We don't use a singleton because we hold on to listeners.
 */
public final class NullPropertyValueModel<T>
	extends AbstractModel
	implements PropertyValueModel<T>, Serializable
{
	private static final long serialVersionUID = 1L;

	/**
	 * Default constructor.
	 */
	public NullPropertyValueModel() {
		super();
	}

	@Override
	public T getValue() {
		return null;
	}

    @Override
	public String toString() {
		return this.getClass().getSimpleName();
	}
}