/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.StackTrace;

public class StackTraceTests
	extends TestCase
{
	public StackTraceTests(String name) {
		super(name);
	}

	public void testToString() throws Exception {
		StackTrace st = new StackTrace();
		assertTrue(st.toString().contains(this.getClass().getName()));
	}

	public void testToString_noTestClass() throws Exception {
		StackTrace st = new StackTrace(this.getClass());
		assertFalse(st.toString().contains(this.getClass().getName()));
	}
}