/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.tools;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.Nominative;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.RenameDialog;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.SessionCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public abstract class AbstractSessionsListPane
extends AbstractSubjectPanel {
    protected AbstractSessionsListPane(PropertyValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super((ValueModel)subjectHolder, contextHolder);
    }

    protected abstract void addNewSession();

    private ListCellRenderer buidlAddRemoveListCellRenderer() {
        return new AdaptableListCellRenderer(new SessionCellRendererAdapter(this.resourceRepository()));
    }

    protected AddRemovePanel.Adapter buildAddRemoveListPanelAdapter() {
        return new AddRemoveListAdapter();
    }

    protected PropertyValueModel buildDisplayStringHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "displayString"){

            @Override
            protected Object getValueFromSubject() {
                Nominative nominative = (Nominative)this.subject;
                return nominative.getName();
            }
        };
    }

    protected PropertyChangeListener buildDisplayStringListener(final TitledBorder border) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getNewValue() != null) {
                    border.setTitle(AbstractSessionsListPane.this.resourceRepository().getString("PROJECT_SESSIONS_LIST", e.getNewValue()));
                    AbstractSessionsListPane.this.repaint();
                }
            }
        };
    }

    protected AddRemoveListPanel buildSessionListPane() {
        return new CustomizedSessionListPanel();
    }

    protected abstract CollectionValueModel buildSessionsCollectionHolder();

    private ItemPropertyListValueModelAdapter buildSessionsItemListAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildSessionsCollectionHolder(), "name");
    }

    private SortedListValueModelAdapter buildSortedSessionsListHolder() {
        return new SortedListValueModelAdapter(this.buildSessionsItemListAdapter());
    }

    protected boolean canRemoveSessions(Collection sessions) {
        return true;
    }

    @Override
    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        TitledBorder border = new TitledBorder("");
        PropertyValueModel displayStringAdapter = this.buildDisplayStringHolder();
        displayStringAdapter.addPropertyChangeListener("value", this.buildDisplayStringListener(border));
        border.setTitle(this.resourceRepository().getString("PROJECT_SESSIONS_LIST", displayStringAdapter.getValue()));
        this.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        AddRemoveListPanel interfacesListPanel = this.buildSessionListPane();
        interfacesListPanel.setCellRenderer(this.buidlAddRemoveListCellRenderer());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)interfacesListPanel, constraints);
        this.addPaneForAlignment(interfacesListPanel);
    }

    protected abstract void removeSessions(Collection var1);

    protected void renameSession(SessionAdapter session) {
        TopLinkSessionsAdapter sessions = (TopLinkSessionsAdapter)session.getParent();
        SimplePropertyValueModel stringHolder = new SimplePropertyValueModel();
        stringHolder.setValue(session.getName());
        RenameDialog dialog = new RenameDialog(this.getWorkbenchContext(), stringHolder, sessions.getAllSessionsNames());
        dialog.setVisible(true);
        if (dialog.wasConfirmed()) {
            session.setName((String)stringHolder.getValue());
        }
    }

    protected class CustomizedSessionListPanel
    extends AddRemoveListPanel {
        protected CustomizedSessionListPanel() {
            super(AbstractSessionsListPane.this.getApplicationContext(), AbstractSessionsListPane.this.buildAddRemoveListPanelAdapter(), (ListValueModel)AbstractSessionsListPane.this.buildSortedSessionsListHolder(), 3);
        }

        @Override
        protected String addButtonKey() {
            return "PROJECT_SESSIONS_ADD_BUTTON";
        }

        @Override
        protected String removeButtonKey() {
            return "PROJECT_SESSIONS_REMOVE_BUTTON";
        }
    }

    protected class AddRemoveListAdapter
    implements AddRemovePanel.OptionAdapter {
        protected AddRemoveListAdapter() {
        }

        @Override
        public void addNewItem(ObjectListSelectionModel listSelectionModel) {
            AbstractSessionsListPane.this.addNewSession();
        }

        @Override
        public String optionalButtonKey() {
            return "PROJECT_SESSIONS_RENAME_BUTTON";
        }

        @Override
        public void optionOnSelection(ObjectListSelectionModel selectionModel) {
            AbstractSessionsListPane.this.renameSession((SessionAdapter)selectionModel.getSelectedValue());
        }

        @Override
        public boolean enableOptionOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
            return listSelectionModel.getSelectedValuesSize() == 1;
        }

        @Override
        public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
            Collection sessions = CollectionTools.collection((Object[])listSelectionModel.getSelectedValues());
            if (AbstractSessionsListPane.this.canRemoveSessions(sessions)) {
                AbstractSessionsListPane.this.removeSessions(sessions);
            }
        }
    }
}

