/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance.concurrent;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.eclipse.persistence.testing.framework.ConcurrentPerformanceComparisonTest;
import org.eclipse.persistence.testing.models.jpa.performance.Employee;
import org.eclipse.persistence.testing.models.jpa.performance.EmployeeService;

public class JPAClusteredEJBConcurrencyComparisonTest
extends ConcurrentPerformanceComparisonTest {
    private List<String> serverURLs;
    protected List<Employee> employees;
    protected ThreadLocal local;
    protected int errors;
    protected int server;
    protected double percentUpdate = 1.0;

    public JPAClusteredEJBConcurrencyComparisonTest() {
        this.setDescription("This test compares the concurrency of a cluster using a remote SessionBean.");
        URL url = ((Object)((Object)this)).getClass().getResource("/weblogic.properties");
        Properties properties = new Properties();
        try {
            properties.load(url.openStream());
        }
        catch (Exception error) {
            throw new RuntimeException(error);
        }
        this.serverURLs = new ArrayList<String>();
        this.serverURLs.add(properties.getProperty("rcm.wls.server1.url"));
        this.serverURLs.add(properties.getProperty("rcm.wls.server2.url"));
        this.serverURLs.add(properties.getProperty("rcm.wls.server3.url"));
        this.local = new ThreadLocal();
    }

    public JPAClusteredEJBConcurrencyComparisonTest(double percentUpdate) {
        this();
        this.percentUpdate = percentUpdate;
        this.setName("JPAClusteredEJBConcurrencyComparisonTest-%update=" + percentUpdate);
    }

    public synchronized int nextServer() {
        ++this.server;
        if (this.server >= this.serverURLs.size()) {
            this.server = 0;
        }
        return this.server;
    }

    public EmployeeService getEmployeeService() {
        EmployeeService service = (EmployeeService)this.local.get();
        if (service == null) {
            service = this.nextEmployeeService();
            this.local.set(service);
        }
        return service;
    }

    public EmployeeService nextEmployeeService() {
        EmployeeService service = null;
        int server = this.nextServer();
        Properties properties = new Properties();
        String url = this.serverURLs.get(server);
        properties.put("java.naming.provider.url", url);
        System.out.println(server + ":" + url);
        try {
            InitialContext context = new InitialContext(properties);
            service = (EmployeeService)PortableRemoteObject.narrow((Object)context.lookup("EmployeeService#org.eclipse.persistence.testing.models.jpa.performance.EmployeeService"), EmployeeService.class);
        }
        catch (Exception notFoundException) {
            throw new Error("Lookup failed.", notFoundException);
        }
        return service;
    }

    public void setup() {
        super.setup();
        this.local = new ThreadLocal();
        this.server = -1;
        EmployeeService service = this.getEmployeeService();
        this.employees = service.findAll();
        this.errors = 0;
    }

    public void runTask() throws Exception {
        try {
            EmployeeService service = this.getEmployeeService();
            int random = (int)(Math.random() * 1000000.0);
            int index = (int)(Math.random() * (double)this.employees.size());
            double update = Math.random();
            boolean success = false;
            int count = 0;
            while (!success && count < 20) {
                ++count;
                Employee employee = service.findById(this.employees.get(index).getId());
                if (update <= this.percentUpdate) {
                    employee.setFirstName(String.valueOf(random));
                    employee.setLastName(String.valueOf(random));
                    employee.setSalary(random);
                    try {
                        service.update(employee);
                        success = true;
                    }
                    catch (Exception exception) {
                        ++this.errors;
                    }
                    continue;
                }
                success = true;
            }
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public void endTest() {
        super.endTest();
        System.out.println("Errors:" + this.errors);
        this.errors = 0;
    }
}

