/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.tests.clientserver.EmployeeSeqDeadlockClient;
import org.eclipse.persistence.testing.tests.clientserver.FIFO;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class EmployeeSeqDeadlockClient2
extends EmployeeSeqDeadlockClient {
    protected FIFO fifoIn;

    public EmployeeSeqDeadlockClient2(Server server, Session session, String name, int maximumLoops, boolean createEmployeesFirst, FIFO fifoOut, FIFO fifoIn) {
        super(server, session, name, maximumLoops, createEmployeesFirst, fifoOut);
        this.fifoIn = fifoIn;
    }

    @Override
    public void run() {
        int i = 0;
        ((ClientSession)this.clientSession).beginTransaction();
        while (this.getKeepRunning()) {
            if (++i > this.getMaximumLoops()) {
                this.pleaseStop();
                continue;
            }
            try {
                if (this.shouldCreateEmployee(i)) {
                    ((ClientSession)this.clientSession).getSequencing().getNextValue(Employee.class);
                } else {
                    ((ClientSession)this.clientSession).getSequencing().getNextValue(SmallProject.class);
                }
                if (this.fifoOut != null) {
                    this.fifoOut.insertTail(new Integer(i));
                }
                if (i != this.getMaximumLoops() / 2 || this.fifoIn == null) continue;
                while (this.fifoIn.removeHead() == null && this.getKeepRunning()) {
                    try {
                        EmployeeSeqDeadlockClient2.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            catch (Exception e) {
                this.pleaseStop();
                this.setErrorOccurred(true);
                this.setTestException(e);
            }
        }
        if (!this.anErrorOccurred()) {
            try {
                ((ClientSession)this.clientSession).commitTransaction();
            }
            catch (Exception e) {
                this.pleaseStop();
                this.setErrorOccurred(true);
                this.setTestException(e);
            }
        } else {
            ((ClientSession)this.clientSession).rollbackTransaction();
        }
        this.session = null;
        this.server = null;
        if (this.fifoOut != null) {
            this.fifoOut.insertTail(new Integer(-1));
        }
    }

    protected boolean shouldCreateEmployee(int i) {
        boolean firstHalf;
        boolean bl = firstHalf = i <= this.getMaximumLoops() / 2;
        if (firstHalf) {
            return this.createEmployees;
        }
        return !this.createEmployees;
    }
}

