/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ShallowRefreshTest
extends TestCase {
    protected Employee originalObject;
    protected String firstName;

    public ShallowRefreshTest() {
        this.setDescription("This test verifies the shallow refresh feature works properly");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void setup() {
        this.originalObject = (Employee)this.getSession().readObject(Employee.class);
    }

    public void test() {
        this.firstName = this.originalObject.getFirstName();
        this.originalObject.setFirstName("Godzilla");
        this.originalObject.getAddress().setCity("Foo Town");
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSelectionObject((Object)this.originalObject);
        query.refreshIdentityMapResult();
        this.getSession().executeQuery((DatabaseQuery)query);
    }

    protected void verify() {
        if (!this.originalObject.getFirstName().equals(this.firstName)) {
            throw new TestErrorException("The shallow refresh test failed.");
        }
        if (!this.originalObject.getAddress().getCity().equals("Foo Town")) {
            throw new TestErrorException("The shallow refresh test failed.");
        }
    }
}

