/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.simultaneous;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.tests.simultaneous.Runner1;
import org.eclipse.persistence.testing.tests.simultaneous.Runner2;

public class ConcurrencyTest
extends AutoVerifyTestCase {
    Employee emp = null;
    SmallProject project = null;

    protected void setup() throws Throwable {
        super.setup();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.project = new SmallProject();
        uow.registerNewObject((Object)this.project);
        this.emp = new Employee();
        uow.registerNewObject((Object)this.emp);
        uow.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void test() throws Throwable {
        super.test();
        Integer i = new Integer(5);
        Thread thread1 = new Thread(new Runner1(i, this.emp.getId(), this.project.getId(), this.getSession()));
        thread1.setName("Runner1");
        Thread thread2 = new Thread(new Runner2(i, this.emp.getId(), this.project.getId(), this.getSession()));
        thread2.setName("Runner2");
        thread2.start();
        thread1.start();
        try {
            Thread.currentThread();
            Thread.sleep(8000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Integer e = i;
        synchronized (e) {
            i.notifyAll();
        }
        try {
            thread2.join(30000L);
            thread1.join(30000L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        if (thread2.isAlive() || thread1.isAlive()) {
            thread2.interrupt();
            thread1.interrupt();
            ConcurrencyTest.fail((String)"Dead-lock occurred");
        }
    }

    public void reset() throws Throwable {
        super.reset();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.emp = (Employee)uow.readObject((Object)this.emp);
        this.emp.getProjects().clear();
        uow.deleteObject(uow.readObject((Object)this.project));
        uow.deleteObject((Object)this.emp);
        uow.commit();
    }
}

