/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentAddress;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentPerson;
import org.eclipse.persistence.testing.tests.unitofwork.LockOnCloneListener;

public class LockOnCloneTest
extends AutoVerifyTestCase {
    public ConcurrentPerson person;
    public ConcurrentPerson cloned;
    public LockOnCloneListener listener = new LockOnCloneListener();

    public LockOnCloneTest() {
        this.setDescription("Tests that TopLink is correctly locking on cloning");
    }

    public void setup() {
        if (this.getSession().isDistributedSession()) {
            throw new TestWarningException("Test unavailable on Remote UnitOfWork because of timing issues");
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getSession().getDescriptor(ConcurrentAddress.class).getEventManager().addListener((DescriptorEventListener)this.listener);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.person = ConcurrentPerson.example1();
        this.person = (ConcurrentPerson)uow.registerObject((Object)this.person);
        uow.commit();
        ConcurrentAddress.RUNNING_TEST = 55;
    }

    public void test() {
        Thread thread1 = new Thread(){

            @Override
            public void run() {
                UnitOfWork uow = LockOnCloneTest.this.getSession().acquireUnitOfWork();
                LockOnCloneTest.this.cloned = (ConcurrentPerson)uow.registerObject((Object)LockOnCloneTest.this.person);
            }
        };
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                LockOnCloneTest.this.getSession().refreshObject((Object)LockOnCloneTest.this.person.address);
            }
        };
        thread1.start();
        thread2.start();
        try {
            thread1.join();
            thread2.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConcurrentAddress.RUNNING_TEST = Integer.MIN_VALUE;
        if (!this.cloned.getAddress().getStreet().equals("Start") || !this.cloned.getAddress().getPostalCode().equals("H0H0H0")) {
            if (!this.cloned.getAddress().getStreet().equals("Corrupted") || !this.cloned.getAddress().getPostalCode().equals("A1A1A1")) {
                throw new TestErrorException("Failed to wholly clone the object");
            }
            this.getSession().logMessage("LockOnCloneTest :-> Clone blocked on Refresh");
        } else {
            this.getSession().logMessage(" LockOnCloneTest :-> refresh blocked on clone");
        }
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteObject((Object)this.person);
        uow.commit();
        this.getSession().getDescriptor(ConcurrentAddress.class).getEventManager().removeListener((DescriptorEventListener)this.listener);
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

