/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class ProxyIndirectionNotAvailableTest
extends ExceptionTest {
    public ProxyIndirectionNotAvailableTest() {
        this.setDescription("This tests Proxy Indirection Not Available (TL-ERROR 159)");
    }

    protected void setup() {
        this.expectedException = DescriptorException.proxyIndirectionNotAvailable(null);
    }

    public void test() {
        ProxyIndirectionPolicy policy = new ProxyIndirectionPolicy();
        try {
            policy.initialize();
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    @Override
    protected void verify() {
        String jdkVersion = System.getProperty("java.version");
        if (jdkVersion.compareTo("1.3.0") < 0) {
            if (this.caughtException == null) {
                throw new TestErrorException("The proper exception was not thrown:" + Helper.cr() + "caught exception was null! \n\n[EXPECTING] " + (Object)((Object)this.expectedException) + " with JDK less than 1.3.0");
            }
            if (this.caughtException.getErrorCode() != this.expectedException.getErrorCode()) {
                throw new TestErrorException("The proper exception was not thrown:" + Helper.cr() + "[CAUGHT] " + (Object)((Object)this.caughtException) + "\n\n[EXPECTING] " + (Object)((Object)this.expectedException) + " with JDK less than 1.3.0");
            }
        } else if (this.caughtException != null) {
            throw new TestErrorException("The proper exception was not thrown:" + Helper.cr() + "[CAUGHT] " + (Object)((Object)this.caughtException) + "\n\n[EXPECTING] no Exception with JDK 1.3");
        }
    }
}

