/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.driver;

import java.util.ArrayList;
import org.eclipse.persistence.tools.db.driver.AbstractWorkbenchDriverAdapter;
import org.eclipse.persistence.tools.db.driver.CatalogStrategy;
import org.eclipse.persistence.tools.db.driver.FauxCatalogStrategy;
import org.eclipse.persistence.tools.db.driver.FoldingStrategy;
import org.eclipse.persistence.tools.db.driver.UpperCaseFoldingStrategy;
import org.eclipse.persistence.tools.db.driver.WorkbenchDriverAdapter;
import org.eclipse.persistence.tools.db.driver.WorkbenchDriverAdapterFactory;
import org.eclipse.persistence.tools.gen.db.Database;

class Derby
extends AbstractWorkbenchDriverAdapter {
    private static final String DEFAULT_USER_NAME = "APP";

    Derby(Database database) {
        super(database);
    }

    @Override
    CatalogStrategy buildCatalogStrategy() {
        return new FauxCatalogStrategy();
    }

    @Override
    FoldingStrategy buildFoldingStrategy() {
        return UpperCaseFoldingStrategy.instance();
    }

    @Override
    void addDefaultSchemaNamesTo(ArrayList<String> names) {
        names.add(this.getDefaultSchemaName());
    }

    private String getDefaultSchemaName() {
        String userName = this.getUserName();
        return userName != null && userName.length() != 0 ? userName : DEFAULT_USER_NAME;
    }

    static class Factory
    implements WorkbenchDriverAdapterFactory {
        private static final String[] VENDORS = new String[]{"Derby"};

        Factory() {
        }

        @Override
        public String[] getSupportedVendors() {
            return VENDORS;
        }

        @Override
        public WorkbenchDriverAdapter buildAdapter(Database database) {
            return new Derby(database);
        }
    }
}

