/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterable;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterable.ArrayIterable;

public abstract class AbstractSimultaneousIterable<E, I extends Iterable<E>> {
    final Iterable<? extends I> iterables;
    final int iterablesSize;

    protected <T extends I> AbstractSimultaneousIterable(T ... iterables) {
        this((Iterable<T>)new ArrayIterable<T>(iterables), iterables.length);
    }

    protected <T extends I> AbstractSimultaneousIterable(Iterable<T> iterables) {
        this(iterables, -1);
    }

    protected <T extends I> AbstractSimultaneousIterable(Iterable<T> iterables, int iterablesSize) {
        if (iterables == null) {
            throw new NullPointerException();
        }
        this.iterables = iterables;
        this.iterablesSize = iterablesSize;
    }

    <T extends Iterator<E>> ArrayList<T> buildList() {
        return this.iterablesSize < 0 ? new ArrayList() : new ArrayList(this.iterablesSize);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.iterables);
    }
}

