/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterable;

import java.util.Iterator;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.iterable.ArrayIterable;
import org.eclipse.persistence.tools.utility.iterable.SingleElementIterable;
import org.eclipse.persistence.tools.utility.iterator.CompositeIterator;
import org.eclipse.persistence.tools.utility.iterator.TransformationIterator;

public class CompositeIterable<E>
implements Iterable<E> {
    private final Iterable<? extends Iterable<? extends E>> iterables;

    public CompositeIterable(Iterable<? extends Iterable<? extends E>> iterables) {
        if (iterables == null) {
            throw new NullPointerException();
        }
        this.iterables = iterables;
    }

    public CompositeIterable(E object, Iterable<? extends E> iterable) {
        this(new Iterable[]{new SingleElementIterable<E>(object), iterable});
    }

    public CompositeIterable(Iterable<? extends E> iterable, E object) {
        this(new Iterable[]{iterable, new SingleElementIterable<E>(object)});
    }

    public CompositeIterable(Iterable<? extends E> ... iterables) {
        this((Iterable<Iterable<? extends E>>)new ArrayIterable<Iterable<? extends E>>(iterables));
    }

    @Override
    public Iterator<E> iterator() {
        return new CompositeIterator<E>(this.iterators());
    }

    protected Iterator<? extends Iterator<? extends E>> iterators() {
        return new TransformationIterator<Iterable<? extends E>, Iterator<? extends E>>(this.iterables()){

            @Override
            protected Iterator<? extends E> transform(Iterable<? extends E> next) {
                return next.iterator();
            }
        };
    }

    protected Iterator<? extends Iterable<? extends E>> iterables() {
        return this.iterables.iterator();
    }

    public String toString() {
        return ListTools.list(this).toString();
    }
}

