/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.transformer;

import org.eclipse.persistence.tools.utility.ArrayTools;
import org.eclipse.persistence.tools.utility.transformer.AbstractTransformer;

public final class XMLStringEncoder
extends AbstractTransformer<String, String> {
    private final char[] chars;
    private final char maxChar;

    public XMLStringEncoder(char[] chars) {
        if (chars == null) {
            throw new NullPointerException();
        }
        this.chars = ArrayTools.contains(chars, '&') ? chars : ArrayTools.add(chars, '&');
        this.maxChar = this.calculateMaxInvalidFileNameChar();
    }

    private char calculateMaxInvalidFileNameChar() {
        char[] localChars = this.chars;
        char max = '\u0000';
        int i = localChars.length;
        while (i-- > 0) {
            char c = localChars[i];
            if (max >= c) continue;
            max = c;
        }
        return max;
    }

    @Override
    protected String transform_(String s) {
        int len = s.length();
        StringBuilder sb = new StringBuilder(len + 20);
        int i = 0;
        while (i < len) {
            this.append(sb, s.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    private void append(StringBuilder sb, char c) {
        if (this.charIsToBeEncoded(c)) {
            this.appendCharacterReference(sb, c);
        } else {
            sb.append(c);
        }
    }

    private boolean charIsToBeEncoded(char c) {
        return c <= this.maxChar && ArrayTools.contains(this.chars, c);
    }

    private void appendCharacterReference(StringBuilder sb, char c) {
        sb.append("&#x");
        sb.append(Integer.toString(c, 16));
        sb.append(';');
    }
}

