/*******************************************************************************
 * Copyright (c) 2008, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility;

import java.io.Serializable;

/**
 * Straightforward implementation of {@link org.eclipse.jpt.common.utility.Association}.
 */
public class SimpleAssociation<K, V>
	extends AbstractAssociation<K, V>
	implements Cloneable, Serializable
{
	private final K key;
	private V value;

	private static final long serialVersionUID = 1L;

	/**
	 * Construct an association with the specified key
	 * and a null value.
	 */
	public SimpleAssociation(K key) {
		super();
		this.key = key;
	}

	/**
	 * Construct an association with the specified key and value.
	 */
	public SimpleAssociation(K key, V value) {
		this(key);
		this.value = value;
	}

	@Override
	public K getKey() {
		return this.key;
	}

	@Override
	public synchronized V getValue() {
		return this.value;
	}

	@Override
	public synchronized V setValue(V value) {
		V old = this.value;
		this.value = value;
		return old;
	}

	@Override
	@SuppressWarnings("unchecked")
	public synchronized SimpleAssociation<K, V> clone() {
		try {
			return (SimpleAssociation<K, V>) super.clone();
		} catch (CloneNotSupportedException ex) {
			throw new InternalError();
		}
	}
}