/*******************************************************************************
 * Copyright (c) 2009, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.persistence.tools.db.driver;

import org.eclipse.persistence.tools.gen.db.Database;

/**
 *
 * @version 2.5
 */
@SuppressWarnings("nls")
class Oracle extends AbstractWorkbenchDriverAdapter {

	private static final char[] EXTENDED_REGULAR_NAME_PART_CHARACTERS = new char[] { '$', '#' };

	Oracle(Database database) {
		super(database);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	CatalogStrategy buildCatalogStrategy() {
		return new FauxCatalogStrategy();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	FoldingStrategy buildFoldingStrategy() {
		return UpperCaseFoldingStrategy.instance();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	char[] getExtendedRegularNamePartCharacters() {
		return EXTENDED_REGULAR_NAME_PART_CHARACTERS;
	}

	// ********** factory **********

	static class Factory implements WorkbenchDriverAdapterFactory {
		private static final String[] VENDORS = {
			"Oracle"
		};
		@Override
		public String[] getSupportedVendors() {
			return VENDORS;
		}
		@Override
		public WorkbenchDriverAdapter buildAdapter(Database database) {
			return new Oracle(database);
		}
	}
}