/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import javax.persistence.EnumType;

/**
 * This interface and inherited behavior describes the configurable properties for a basic mapping
 * in the ORM xml. A basic mapping may be defined on either a mapped superclass or regular entity.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.Basic
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html,
 * persistence specificaton
 *
 * @version 2.5
 * @author John Bracken
 */
public interface ExternalBasicMapping extends ExternalVersionMapping,
                                              ExternalGeneratedMapping,
                                              ExternalMappedMapping   {

	/**
	 * Returns the enumerated type of this mapping if one exists.
	 */
	EnumType getEnumeratedType();

	/**
	 * Indicates whether this basic mapping's column is a LOB.
	 */
	Boolean isLob();

	/**
	 * Returns whether this mapping returns on insert.
	 */
	Boolean returnOnInsert();

	/**
	 * Returns whether this mapping returns only on insert.
	 */
	Boolean returnOnlyOnInsert();

	/**
	 * Returns whether this mapping returns on update.
	 */
	Boolean returnOnUpdate();

	/**
	 * Sets enumerated type.
	 */
	void setEnumeratedType(EnumType type);

	/**
	 * Sets mapping as lob.
	 */
	void setLob(Boolean lob);

	/**
	 * Sets whether this mapping returns on insert.
	 */
	void setReturnOnInsert(Boolean returnOnInsert);

	/**
	 * Sets whether this mapping only returns on insert.
	 */
	void setReturnOnlyOnInsert(Boolean returnOnlyOnInsert);

	/**
	 * Sets whether this mapping returns on update.
	 */
	void setReturnOnUpdate(Boolean returnOnUpdate);
}